<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for attachments StructType
 * @subpackage Structs
 */
class Attachments extends AbstractStructBase
{
    /**
     * The Attachment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Attachment[]
     */
    public $Attachment;
    /**
     * Constructor method for attachments
     * @uses Attachments::setAttachment()
     * @param \StructType\Attachment[] $attachment
     */
    public function __construct(array $attachment = array())
    {
        $this
            ->setAttachment($attachment);
    }
    /**
     * Get Attachment value
     * @return \StructType\Attachment[]|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }
    /**
     * Set Attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment[] $attachment
     * @return \StructType\Attachments
     */
    public function setAttachment(array $attachment = array())
    {
        foreach ($attachment as $attachmentsAttachmentItem) {
            // validation for constraint: itemType
            if (!$attachmentsAttachmentItem instanceof \StructType\Attachment) {
                throw new \InvalidArgumentException(sprintf('The Attachment property can only contain items of \StructType\Attachment, "%s" given', is_object($attachmentsAttachmentItem) ? get_class($attachmentsAttachmentItem) : gettype($attachmentsAttachmentItem)), __LINE__);
            }
        }
        $this->Attachment = $attachment;
        return $this;
    }
    /**
     * Add item to Attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment $item
     * @return \StructType\Attachments
     */
    public function addToAttachment(\StructType\Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attachment) {
            throw new \InvalidArgumentException(sprintf('The Attachment property can only contain items of \StructType\Attachment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Attachment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Attachments
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
