<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attachment StructType
 * @subpackage Structs
 */
class Attachment extends AbstractStructBase
{
    /**
     * The inputFormat
     * @var string
     */
    public $inputFormat;
    /**
     * The outputFormat
     * @var string
     */
    public $outputFormat;
    /**
     * The stylesheet
     * @var string
     */
    public $stylesheet;
    /**
     * The outputName
     * @var string
     */
    public $outputName;
    /**
     * The sourceAttachment
     * @var \StructType\WSFile
     */
    public $sourceAttachment;
    /**
     * The nConvertedAttachments
     * @var int
     */
    public $nConvertedAttachments;
    /**
     * The convertedAttachments
     * Meta informations extracted from the WSDL
     * - SizeIs: nConvertedAttachments
     * - nillable: true
     * @var \StructType\ConvertedAttachments
     */
    public $convertedAttachments;
    /**
     * The nVars
     * @var int
     */
    public $nVars;
    /**
     * The vars
     * Meta informations extracted from the WSDL
     * - SizeIs: nVars
     * - nillable: true
     * @var \StructType\Vars
     */
    public $vars;
    /**
     * Constructor method for Attachment
     * @uses Attachment::setInputFormat()
     * @uses Attachment::setOutputFormat()
     * @uses Attachment::setStylesheet()
     * @uses Attachment::setOutputName()
     * @uses Attachment::setSourceAttachment()
     * @uses Attachment::setNConvertedAttachments()
     * @uses Attachment::setConvertedAttachments()
     * @uses Attachment::setNVars()
     * @uses Attachment::setVars()
     * @param string $inputFormat
     * @param string $outputFormat
     * @param string $stylesheet
     * @param string $outputName
     * @param \StructType\WSFile $sourceAttachment
     * @param int $nConvertedAttachments
     * @param \StructType\ConvertedAttachments $convertedAttachments
     * @param int $nVars
     * @param \StructType\Vars $vars
     */
    public function __construct($inputFormat = null, $outputFormat = null, $stylesheet = null, $outputName = null, \StructType\WSFile $sourceAttachment = null, $nConvertedAttachments = null, \StructType\ConvertedAttachments $convertedAttachments = null, $nVars = null, \StructType\Vars $vars = null)
    {
        $this
            ->setInputFormat($inputFormat)
            ->setOutputFormat($outputFormat)
            ->setStylesheet($stylesheet)
            ->setOutputName($outputName)
            ->setSourceAttachment($sourceAttachment)
            ->setNConvertedAttachments($nConvertedAttachments)
            ->setConvertedAttachments($convertedAttachments)
            ->setNVars($nVars)
            ->setVars($vars);
    }
    /**
     * Get inputFormat value
     * @return string|null
     */
    public function getInputFormat()
    {
        return $this->inputFormat;
    }
    /**
     * Set inputFormat value
     * @param string $inputFormat
     * @return \StructType\Attachment
     */
    public function setInputFormat($inputFormat = null)
    {
        // validation for constraint: string
        if (!is_null($inputFormat) && !is_string($inputFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inputFormat)), __LINE__);
        }
        $this->inputFormat = $inputFormat;
        return $this;
    }
    /**
     * Get outputFormat value
     * @return string|null
     */
    public function getOutputFormat()
    {
        return $this->outputFormat;
    }
    /**
     * Set outputFormat value
     * @param string $outputFormat
     * @return \StructType\Attachment
     */
    public function setOutputFormat($outputFormat = null)
    {
        // validation for constraint: string
        if (!is_null($outputFormat) && !is_string($outputFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($outputFormat)), __LINE__);
        }
        $this->outputFormat = $outputFormat;
        return $this;
    }
    /**
     * Get stylesheet value
     * @return string|null
     */
    public function getStylesheet()
    {
        return $this->stylesheet;
    }
    /**
     * Set stylesheet value
     * @param string $stylesheet
     * @return \StructType\Attachment
     */
    public function setStylesheet($stylesheet = null)
    {
        // validation for constraint: string
        if (!is_null($stylesheet) && !is_string($stylesheet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stylesheet)), __LINE__);
        }
        $this->stylesheet = $stylesheet;
        return $this;
    }
    /**
     * Get outputName value
     * @return string|null
     */
    public function getOutputName()
    {
        return $this->outputName;
    }
    /**
     * Set outputName value
     * @param string $outputName
     * @return \StructType\Attachment
     */
    public function setOutputName($outputName = null)
    {
        // validation for constraint: string
        if (!is_null($outputName) && !is_string($outputName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($outputName)), __LINE__);
        }
        $this->outputName = $outputName;
        return $this;
    }
    /**
     * Get sourceAttachment value
     * @return \StructType\WSFile|null
     */
    public function getSourceAttachment()
    {
        return $this->sourceAttachment;
    }
    /**
     * Set sourceAttachment value
     * @param \StructType\WSFile $sourceAttachment
     * @return \StructType\Attachment
     */
    public function setSourceAttachment(\StructType\WSFile $sourceAttachment = null)
    {
        $this->sourceAttachment = $sourceAttachment;
        return $this;
    }
    /**
     * Get nConvertedAttachments value
     * @return int|null
     */
    public function getNConvertedAttachments()
    {
        return $this->nConvertedAttachments;
    }
    /**
     * Set nConvertedAttachments value
     * @param int $nConvertedAttachments
     * @return \StructType\Attachment
     */
    public function setNConvertedAttachments($nConvertedAttachments = null)
    {
        // validation for constraint: int
        if (!is_null($nConvertedAttachments) && !is_numeric($nConvertedAttachments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nConvertedAttachments)), __LINE__);
        }
        $this->nConvertedAttachments = $nConvertedAttachments;
        return $this;
    }
    /**
     * Get convertedAttachments value
     * @return \StructType\ConvertedAttachments|null
     */
    public function getConvertedAttachments()
    {
        return $this->convertedAttachments;
    }
    /**
     * Set convertedAttachments value
     * @param \StructType\ConvertedAttachments $convertedAttachments
     * @return \StructType\Attachment
     */
    public function setConvertedAttachments(\StructType\ConvertedAttachments $convertedAttachments = null)
    {
        $this->convertedAttachments = $convertedAttachments;
        return $this;
    }
    /**
     * Get nVars value
     * @return int|null
     */
    public function getNVars()
    {
        return $this->nVars;
    }
    /**
     * Set nVars value
     * @param int $nVars
     * @return \StructType\Attachment
     */
    public function setNVars($nVars = null)
    {
        // validation for constraint: int
        if (!is_null($nVars) && !is_numeric($nVars)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nVars)), __LINE__);
        }
        $this->nVars = $nVars;
        return $this;
    }
    /**
     * Get vars value
     * @return \StructType\Vars|null
     */
    public function getVars()
    {
        return $this->vars;
    }
    /**
     * Set vars value
     * @param \StructType\Vars $vars
     * @return \StructType\Attachment
     */
    public function setVars(\StructType\Vars $vars = null)
    {
        $this->vars = $vars;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Attachment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
