<?php

namespace EnumType;

/**
 * This class stands for VAR_TYPE EnumType
 * @subpackage Enumerations
 */
class VAR_TYPE
{
    /**
     * Constant for value 'TYPE_STRING'
     * @return string 'TYPE_STRING'
     */
    const VALUE_TYPE_STRING = 'TYPE_STRING';
    /**
     * Constant for value 'TYPE_DATETIME'
     * @return string 'TYPE_DATETIME'
     */
    const VALUE_TYPE_DATETIME = 'TYPE_DATETIME';
    /**
     * Constant for value 'TYPE_DOUBLE'
     * @return string 'TYPE_DOUBLE'
     */
    const VALUE_TYPE_DOUBLE = 'TYPE_DOUBLE';
    /**
     * Constant for value 'TYPE_INTEGER'
     * @return string 'TYPE_INTEGER'
     */
    const VALUE_TYPE_INTEGER = 'TYPE_INTEGER';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TYPE_STRING
     * @uses self::VALUE_TYPE_DATETIME
     * @uses self::VALUE_TYPE_DOUBLE
     * @uses self::VALUE_TYPE_INTEGER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TYPE_STRING,
            self::VALUE_TYPE_DATETIME,
            self::VALUE_TYPE_DOUBLE,
            self::VALUE_TYPE_INTEGER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
