<?php

namespace EnumType;

/**
 * This class stands for ATTACHMENTS_FILTER EnumType
 * @subpackage Enumerations
 */
class ATTACHMENTS_FILTER
{
    /**
     * Constant for value 'FILTER_NONE'
     * @return string 'FILTER_NONE'
     */
    const VALUE_FILTER_NONE = 'FILTER_NONE';
    /**
     * Constant for value 'FILTER_ALL'
     * @return string 'FILTER_ALL'
     */
    const VALUE_FILTER_ALL = 'FILTER_ALL';
    /**
     * Constant for value 'FILTER_CONVERTED'
     * @return string 'FILTER_CONVERTED'
     */
    const VALUE_FILTER_CONVERTED = 'FILTER_CONVERTED';
    /**
     * Constant for value 'FILTER_SOURCE'
     * @return string 'FILTER_SOURCE'
     */
    const VALUE_FILTER_SOURCE = 'FILTER_SOURCE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FILTER_NONE
     * @uses self::VALUE_FILTER_ALL
     * @uses self::VALUE_FILTER_CONVERTED
     * @uses self::VALUE_FILTER_SOURCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FILTER_NONE,
            self::VALUE_FILTER_ALL,
            self::VALUE_FILTER_CONVERTED,
            self::VALUE_FILTER_SOURCE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
