<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Var StructType
 * @subpackage Structs
 */
class _Var extends AbstractStructBase
{
    /**
     * The attribute
     * @var string
     */
    public $attribute;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The simpleValue
     * @var string
     */
    public $simpleValue;
    /**
     * The nValues
     * @var int
     */
    public $nValues;
    /**
     * The multipleStringValues
     * Meta informations extracted from the WSDL
     * - SizeIs: nValues
     * - nillable: true
     * @var \StructType\MultipleStringValues
     */
    public $multipleStringValues;
    /**
     * The multipleLongValues
     * Meta informations extracted from the WSDL
     * - SizeIs: nValues
     * - nillable: true
     * @var \StructType\MultipleLongValues
     */
    public $multipleLongValues;
    /**
     * The multipleDoubleValues
     * Meta informations extracted from the WSDL
     * - SizeIs: nValues
     * - nillable: true
     * @var \StructType\MultipleDoubleValues
     */
    public $multipleDoubleValues;
    /**
     * Constructor method for Var
     * @uses _Var::setAttribute()
     * @uses _Var::setType()
     * @uses _Var::setSimpleValue()
     * @uses _Var::setNValues()
     * @uses _Var::setMultipleStringValues()
     * @uses _Var::setMultipleLongValues()
     * @uses _Var::setMultipleDoubleValues()
     * @param string $attribute
     * @param string $type
     * @param string $simpleValue
     * @param int $nValues
     * @param \StructType\MultipleStringValues $multipleStringValues
     * @param \StructType\MultipleLongValues $multipleLongValues
     * @param \StructType\MultipleDoubleValues $multipleDoubleValues
     */
    public function __construct($attribute = null, $type = null, $simpleValue = null, $nValues = null, \StructType\MultipleStringValues $multipleStringValues = null, \StructType\MultipleLongValues $multipleLongValues = null, \StructType\MultipleDoubleValues $multipleDoubleValues = null)
    {
        $this
            ->setAttribute($attribute)
            ->setType($type)
            ->setSimpleValue($simpleValue)
            ->setNValues($nValues)
            ->setMultipleStringValues($multipleStringValues)
            ->setMultipleLongValues($multipleLongValues)
            ->setMultipleDoubleValues($multipleDoubleValues);
    }
    /**
     * Get attribute value
     * @return string|null
     */
    public function getAttribute()
    {
        return $this->attribute;
    }
    /**
     * Set attribute value
     * @param string $attribute
     * @return \StructType\_Var
     */
    public function setAttribute($attribute = null)
    {
        // validation for constraint: string
        if (!is_null($attribute) && !is_string($attribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attribute)), __LINE__);
        }
        $this->attribute = $attribute;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\VAR_TYPE::valueIsValid()
     * @uses \EnumType\VAR_TYPE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\_Var
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VAR_TYPE::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\VAR_TYPE::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get simpleValue value
     * @return string|null
     */
    public function getSimpleValue()
    {
        return $this->simpleValue;
    }
    /**
     * Set simpleValue value
     * @param string $simpleValue
     * @return \StructType\_Var
     */
    public function setSimpleValue($simpleValue = null)
    {
        // validation for constraint: string
        if (!is_null($simpleValue) && !is_string($simpleValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($simpleValue)), __LINE__);
        }
        $this->simpleValue = $simpleValue;
        return $this;
    }
    /**
     * Get nValues value
     * @return int|null
     */
    public function getNValues()
    {
        return $this->nValues;
    }
    /**
     * Set nValues value
     * @param int $nValues
     * @return \StructType\_Var
     */
    public function setNValues($nValues = null)
    {
        // validation for constraint: int
        if (!is_null($nValues) && !is_numeric($nValues)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nValues)), __LINE__);
        }
        $this->nValues = $nValues;
        return $this;
    }
    /**
     * Get multipleStringValues value
     * @return \StructType\MultipleStringValues|null
     */
    public function getMultipleStringValues()
    {
        return $this->multipleStringValues;
    }
    /**
     * Set multipleStringValues value
     * @param \StructType\MultipleStringValues $multipleStringValues
     * @return \StructType\_Var
     */
    public function setMultipleStringValues(\StructType\MultipleStringValues $multipleStringValues = null)
    {
        $this->multipleStringValues = $multipleStringValues;
        return $this;
    }
    /**
     * Get multipleLongValues value
     * @return \StructType\MultipleLongValues|null
     */
    public function getMultipleLongValues()
    {
        return $this->multipleLongValues;
    }
    /**
     * Set multipleLongValues value
     * @param \StructType\MultipleLongValues $multipleLongValues
     * @return \StructType\_Var
     */
    public function setMultipleLongValues(\StructType\MultipleLongValues $multipleLongValues = null)
    {
        $this->multipleLongValues = $multipleLongValues;
        return $this;
    }
    /**
     * Get multipleDoubleValues value
     * @return \StructType\MultipleDoubleValues|null
     */
    public function getMultipleDoubleValues()
    {
        return $this->multipleDoubleValues;
    }
    /**
     * Set multipleDoubleValues value
     * @param \StructType\MultipleDoubleValues $multipleDoubleValues
     * @return \StructType\_Var
     */
    public function setMultipleDoubleValues(\StructType\MultipleDoubleValues $multipleDoubleValues = null)
    {
        $this->multipleDoubleValues = $multipleDoubleValues;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\_Var
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
