<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSFile StructType
 * @subpackage Structs
 */
class WSFile extends AbstractStructBase
{
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The mode
     * @var string
     */
    public $mode;
    /**
     * The content
     * @var string
     */
    public $content;
    /**
     * The url
     * @var string
     */
    public $url;
    /**
     * The storageID
     * @var string
     */
    public $storageID;
    /**
     * Constructor method for WSFile
     * @uses WSFile::setName()
     * @uses WSFile::setMode()
     * @uses WSFile::setContent()
     * @uses WSFile::setUrl()
     * @uses WSFile::setStorageID()
     * @param string $name
     * @param string $mode
     * @param string $content
     * @param string $url
     * @param string $storageID
     */
    public function __construct($name = null, $mode = null, $content = null, $url = null, $storageID = null)
    {
        $this
            ->setName($name)
            ->setMode($mode)
            ->setContent($content)
            ->setUrl($url)
            ->setStorageID($storageID);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\WSFile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get mode value
     * @return string|null
     */
    public function getMode()
    {
        return $this->mode;
    }
    /**
     * Set mode value
     * @uses \EnumType\WSFILE_MODE::valueIsValid()
     * @uses \EnumType\WSFILE_MODE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mode
     * @return \StructType\WSFile
     */
    public function setMode($mode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WSFILE_MODE::valueIsValid($mode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mode, implode(', ', \EnumType\WSFILE_MODE::getValidValues())), __LINE__);
        }
        $this->mode = $mode;
        return $this;
    }
    /**
     * Get content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return \StructType\WSFile
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \StructType\WSFile
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get storageID value
     * @return string|null
     */
    public function getStorageID()
    {
        return $this->storageID;
    }
    /**
     * Set storageID value
     * @param string $storageID
     * @return \StructType\WSFile
     */
    public function setStorageID($storageID = null)
    {
        // validation for constraint: string
        if (!is_null($storageID) && !is_string($storageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($storageID)), __LINE__);
        }
        $this->storageID = $storageID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WSFile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
