<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadFileAppend StructType
 * @subpackage Structs
 */
class UploadFileAppend extends AbstractStructBase
{
    /**
     * The fileContent
     * @var string
     */
    public $fileContent;
    /**
     * The destWSFile
     * @var \StructType\WSFile
     */
    public $destWSFile;
    /**
     * Constructor method for UploadFileAppend
     * @uses UploadFileAppend::setFileContent()
     * @uses UploadFileAppend::setDestWSFile()
     * @param string $fileContent
     * @param \StructType\WSFile $destWSFile
     */
    public function __construct($fileContent = null, \StructType\WSFile $destWSFile = null)
    {
        $this
            ->setFileContent($fileContent)
            ->setDestWSFile($destWSFile);
    }
    /**
     * Get fileContent value
     * @return string|null
     */
    public function getFileContent()
    {
        return $this->fileContent;
    }
    /**
     * Set fileContent value
     * @param string $fileContent
     * @return \StructType\UploadFileAppend
     */
    public function setFileContent($fileContent = null)
    {
        // validation for constraint: string
        if (!is_null($fileContent) && !is_string($fileContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileContent)), __LINE__);
        }
        $this->fileContent = $fileContent;
        return $this;
    }
    /**
     * Get destWSFile value
     * @return \StructType\WSFile|null
     */
    public function getDestWSFile()
    {
        return $this->destWSFile;
    }
    /**
     * Set destWSFile value
     * @param \StructType\WSFile $destWSFile
     * @return \StructType\UploadFileAppend
     */
    public function setDestWSFile(\StructType\WSFile $destWSFile = null)
    {
        $this->destWSFile = $destWSFile;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UploadFileAppend
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
