<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for transports StructType
 * @subpackage Structs
 */
class Transports extends AbstractStructBase
{
    /**
     * The Transport
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Transport[]
     */
    public $Transport;
    /**
     * Constructor method for transports
     * @uses Transports::setTransport()
     * @param \StructType\Transport[] $transport
     */
    public function __construct(array $transport = array())
    {
        $this
            ->setTransport($transport);
    }
    /**
     * Get Transport value
     * @return \StructType\Transport[]|null
     */
    public function getTransport()
    {
        return $this->Transport;
    }
    /**
     * Set Transport value
     * @throws \InvalidArgumentException
     * @param \StructType\Transport[] $transport
     * @return \StructType\Transports
     */
    public function setTransport(array $transport = array())
    {
        foreach ($transport as $transportsTransportItem) {
            // validation for constraint: itemType
            if (!$transportsTransportItem instanceof \StructType\Transport) {
                throw new \InvalidArgumentException(sprintf('The Transport property can only contain items of \StructType\Transport, "%s" given', is_object($transportsTransportItem) ? get_class($transportsTransportItem) : gettype($transportsTransportItem)), __LINE__);
            }
        }
        $this->Transport = $transport;
        return $this;
    }
    /**
     * Add item to Transport value
     * @throws \InvalidArgumentException
     * @param \StructType\Transport $item
     * @return \StructType\Transports
     */
    public function addToTransport(\StructType\Transport $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Transport) {
            throw new \InvalidArgumentException(sprintf('The Transport property can only contain items of \StructType\Transport, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Transport[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Transports
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
