<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transport StructType
 * @subpackage Structs
 */
class Transport extends AbstractStructBase
{
    /**
     * The transportName
     * @var string
     */
    public $transportName;
    /**
     * The recipientType
     * @var string
     */
    public $recipientType;
    /**
     * The transportIndex
     * @var string
     */
    public $transportIndex;
    /**
     * The nVars
     * @var int
     */
    public $nVars;
    /**
     * The vars
     * Meta informations extracted from the WSDL
     * - SizeIs: nVars
     * - nillable: true
     * @var \StructType\Vars
     */
    public $vars;
    /**
     * The nSubnodes
     * @var int
     */
    public $nSubnodes;
    /**
     * The subnodes
     * Meta informations extracted from the WSDL
     * - SizeIs: nSubnodes
     * - nillable: true
     * @var \StructType\Subnodes
     */
    public $subnodes;
    /**
     * The nAttachments
     * @var int
     */
    public $nAttachments;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - SizeIs: nAttachments
     * - nillable: true
     * @var \StructType\Attachments
     */
    public $attachments;
    /**
     * Constructor method for Transport
     * @uses Transport::setTransportName()
     * @uses Transport::setRecipientType()
     * @uses Transport::setTransportIndex()
     * @uses Transport::setNVars()
     * @uses Transport::setVars()
     * @uses Transport::setNSubnodes()
     * @uses Transport::setSubnodes()
     * @uses Transport::setNAttachments()
     * @uses Transport::setAttachments()
     * @param string $transportName
     * @param string $recipientType
     * @param string $transportIndex
     * @param int $nVars
     * @param \StructType\Vars $vars
     * @param int $nSubnodes
     * @param \StructType\Subnodes $subnodes
     * @param int $nAttachments
     * @param \StructType\Attachments $attachments
     */
    public function __construct($transportName = null, $recipientType = null, $transportIndex = null, $nVars = null, \StructType\Vars $vars = null, $nSubnodes = null, \StructType\Subnodes $subnodes = null, $nAttachments = null, \StructType\Attachments $attachments = null)
    {
        $this
            ->setTransportName($transportName)
            ->setRecipientType($recipientType)
            ->setTransportIndex($transportIndex)
            ->setNVars($nVars)
            ->setVars($vars)
            ->setNSubnodes($nSubnodes)
            ->setSubnodes($subnodes)
            ->setNAttachments($nAttachments)
            ->setAttachments($attachments);
    }
    /**
     * Get transportName value
     * @return string|null
     */
    public function getTransportName()
    {
        return $this->transportName;
    }
    /**
     * Set transportName value
     * @param string $transportName
     * @return \StructType\Transport
     */
    public function setTransportName($transportName = null)
    {
        // validation for constraint: string
        if (!is_null($transportName) && !is_string($transportName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transportName)), __LINE__);
        }
        $this->transportName = $transportName;
        return $this;
    }
    /**
     * Get recipientType value
     * @return string|null
     */
    public function getRecipientType()
    {
        return $this->recipientType;
    }
    /**
     * Set recipientType value
     * @param string $recipientType
     * @return \StructType\Transport
     */
    public function setRecipientType($recipientType = null)
    {
        // validation for constraint: string
        if (!is_null($recipientType) && !is_string($recipientType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recipientType)), __LINE__);
        }
        $this->recipientType = $recipientType;
        return $this;
    }
    /**
     * Get transportIndex value
     * @return string|null
     */
    public function getTransportIndex()
    {
        return $this->transportIndex;
    }
    /**
     * Set transportIndex value
     * @param string $transportIndex
     * @return \StructType\Transport
     */
    public function setTransportIndex($transportIndex = null)
    {
        // validation for constraint: string
        if (!is_null($transportIndex) && !is_string($transportIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transportIndex)), __LINE__);
        }
        $this->transportIndex = $transportIndex;
        return $this;
    }
    /**
     * Get nVars value
     * @return int|null
     */
    public function getNVars()
    {
        return $this->nVars;
    }
    /**
     * Set nVars value
     * @param int $nVars
     * @return \StructType\Transport
     */
    public function setNVars($nVars = null)
    {
        // validation for constraint: int
        if (!is_null($nVars) && !is_numeric($nVars)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nVars)), __LINE__);
        }
        $this->nVars = $nVars;
        return $this;
    }
    /**
     * Get vars value
     * @return \StructType\Vars|null
     */
    public function getVars()
    {
        return $this->vars;
    }
    /**
     * Set vars value
     * @param \StructType\Vars $vars
     * @return \StructType\Transport
     */
    public function setVars(\StructType\Vars $vars = null)
    {
        $this->vars = $vars;
        return $this;
    }
    /**
     * Get nSubnodes value
     * @return int|null
     */
    public function getNSubnodes()
    {
        return $this->nSubnodes;
    }
    /**
     * Set nSubnodes value
     * @param int $nSubnodes
     * @return \StructType\Transport
     */
    public function setNSubnodes($nSubnodes = null)
    {
        // validation for constraint: int
        if (!is_null($nSubnodes) && !is_numeric($nSubnodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nSubnodes)), __LINE__);
        }
        $this->nSubnodes = $nSubnodes;
        return $this;
    }
    /**
     * Get subnodes value
     * @return \StructType\Subnodes|null
     */
    public function getSubnodes()
    {
        return $this->subnodes;
    }
    /**
     * Set subnodes value
     * @param \StructType\Subnodes $subnodes
     * @return \StructType\Transport
     */
    public function setSubnodes(\StructType\Subnodes $subnodes = null)
    {
        $this->subnodes = $subnodes;
        return $this;
    }
    /**
     * Get nAttachments value
     * @return int|null
     */
    public function getNAttachments()
    {
        return $this->nAttachments;
    }
    /**
     * Set nAttachments value
     * @param int $nAttachments
     * @return \StructType\Transport
     */
    public function setNAttachments($nAttachments = null)
    {
        // validation for constraint: int
        if (!is_null($nAttachments) && !is_numeric($nAttachments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nAttachments)), __LINE__);
        }
        $this->nAttachments = $nAttachments;
        return $this;
    }
    /**
     * Get attachments value
     * @return \StructType\Attachments|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @param \StructType\Attachments $attachments
     * @return \StructType\Transport
     */
    public function setAttachments(\StructType\Attachments $attachments = null)
    {
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Transport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
