<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubmissionResults StructType
 * @subpackage Structs
 */
class SubmissionResults extends AbstractStructBase
{
    /**
     * The submissionID
     * @var string
     */
    public $submissionID;
    /**
     * The nTransport
     * @var int
     */
    public $nTransport;
    /**
     * The transportIDs
     * Meta informations extracted from the WSDL
     * - SizeIs: nTransport
     * - nillable: true
     * @var \StructType\TransportIDs
     */
    public $transportIDs;
    /**
     * Constructor method for SubmissionResults
     * @uses SubmissionResults::setSubmissionID()
     * @uses SubmissionResults::setNTransport()
     * @uses SubmissionResults::setTransportIDs()
     * @param string $submissionID
     * @param int $nTransport
     * @param \StructType\TransportIDs $transportIDs
     */
    public function __construct($submissionID = null, $nTransport = null, \StructType\TransportIDs $transportIDs = null)
    {
        $this
            ->setSubmissionID($submissionID)
            ->setNTransport($nTransport)
            ->setTransportIDs($transportIDs);
    }
    /**
     * Get submissionID value
     * @return string|null
     */
    public function getSubmissionID()
    {
        return $this->submissionID;
    }
    /**
     * Set submissionID value
     * @param string $submissionID
     * @return \StructType\SubmissionResults
     */
    public function setSubmissionID($submissionID = null)
    {
        // validation for constraint: string
        if (!is_null($submissionID) && !is_string($submissionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($submissionID)), __LINE__);
        }
        $this->submissionID = $submissionID;
        return $this;
    }
    /**
     * Get nTransport value
     * @return int|null
     */
    public function getNTransport()
    {
        return $this->nTransport;
    }
    /**
     * Set nTransport value
     * @param int $nTransport
     * @return \StructType\SubmissionResults
     */
    public function setNTransport($nTransport = null)
    {
        // validation for constraint: int
        if (!is_null($nTransport) && !is_numeric($nTransport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nTransport)), __LINE__);
        }
        $this->nTransport = $nTransport;
        return $this;
    }
    /**
     * Get transportIDs value
     * @return \StructType\TransportIDs|null
     */
    public function getTransportIDs()
    {
        return $this->transportIDs;
    }
    /**
     * Set transportIDs value
     * @param \StructType\TransportIDs $transportIDs
     * @return \StructType\SubmissionResults
     */
    public function setTransportIDs(\StructType\TransportIDs $transportIDs = null)
    {
        $this->transportIDs = $transportIDs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubmissionResults
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
