<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubmissionResult StructType
 * @subpackage Structs
 */
class SubmissionResult extends AbstractStructBase
{
    /**
     * The submissionID
     * @var string
     */
    public $submissionID;
    /**
     * The transportID
     * @var string
     */
    public $transportID;
    /**
     * Constructor method for SubmissionResult
     * @uses SubmissionResult::setSubmissionID()
     * @uses SubmissionResult::setTransportID()
     * @param string $submissionID
     * @param string $transportID
     */
    public function __construct($submissionID = null, $transportID = null)
    {
        $this
            ->setSubmissionID($submissionID)
            ->setTransportID($transportID);
    }
    /**
     * Get submissionID value
     * @return string|null
     */
    public function getSubmissionID()
    {
        return $this->submissionID;
    }
    /**
     * Set submissionID value
     * @param string $submissionID
     * @return \StructType\SubmissionResult
     */
    public function setSubmissionID($submissionID = null)
    {
        // validation for constraint: string
        if (!is_null($submissionID) && !is_string($submissionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($submissionID)), __LINE__);
        }
        $this->submissionID = $submissionID;
        return $this;
    }
    /**
     * Get transportID value
     * @return string|null
     */
    public function getTransportID()
    {
        return $this->transportID;
    }
    /**
     * Set transportID value
     * @param string $transportID
     * @return \StructType\SubmissionResult
     */
    public function setTransportID($transportID = null)
    {
        // validation for constraint: string
        if (!is_null($transportID) && !is_string($transportID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transportID)), __LINE__);
        }
        $this->transportID = $transportID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubmissionResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
