<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for multipleLongValues StructType
 * @subpackage Structs
 */
class MultipleLongValues extends AbstractStructBase
{
    /**
     * The int
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $int;
    /**
     * Constructor method for multipleLongValues
     * @uses MultipleLongValues::setInt()
     * @param int[] $int
     */
    public function __construct(array $int = array())
    {
        $this
            ->setInt($int);
    }
    /**
     * Get int value
     * @return int[]|null
     */
    public function getInt()
    {
        return $this->int;
    }
    /**
     * Set int value
     * @throws \InvalidArgumentException
     * @param int[] $int
     * @return \StructType\MultipleLongValues
     */
    public function setInt(array $int = array())
    {
        foreach ($int as $multipleLongValuesIntItem) {
            // validation for constraint: itemType
            if (!is_numeric($multipleLongValuesIntItem)) {
                throw new \InvalidArgumentException(sprintf('The int property can only contain items of int, "%s" given', is_object($multipleLongValuesIntItem) ? get_class($multipleLongValuesIntItem) : gettype($multipleLongValuesIntItem)), __LINE__);
            }
        }
        $this->int = $int;
        return $this;
    }
    /**
     * Add item to int value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\MultipleLongValues
     */
    public function addToInt($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The int property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->int[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MultipleLongValues
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
