<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for multipleDoubleValues StructType
 * @subpackage Structs
 */
class MultipleDoubleValues extends AbstractStructBase
{
    /**
     * The double
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var float[]
     */
    public $double;
    /**
     * Constructor method for multipleDoubleValues
     * @uses MultipleDoubleValues::setDouble()
     * @param float[] $double
     */
    public function __construct(array $double = array())
    {
        $this
            ->setDouble($double);
    }
    /**
     * Get double value
     * @return float[]|null
     */
    public function getDouble()
    {
        return $this->double;
    }
    /**
     * Set double value
     * @throws \InvalidArgumentException
     * @param float[] $double
     * @return \StructType\MultipleDoubleValues
     */
    public function setDouble(array $double = array())
    {
        foreach ($double as $multipleDoubleValuesDoubleItem) {
            // validation for constraint: itemType
            if (!is_float($multipleDoubleValuesDoubleItem)) {
                throw new \InvalidArgumentException(sprintf('The double property can only contain items of double, "%s" given', is_object($multipleDoubleValuesDoubleItem) ? get_class($multipleDoubleValuesDoubleItem) : gettype($multipleDoubleValuesDoubleItem)), __LINE__);
            }
        }
        $this->double = $double;
        return $this;
    }
    /**
     * Add item to double value
     * @throws \InvalidArgumentException
     * @param float $item
     * @return \StructType\MultipleDoubleValues
     */
    public function addToDouble($item)
    {
        // validation for constraint: itemType
        if (!is_float($item)) {
            throw new \InvalidArgumentException(sprintf('The double property can only contain items of double, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->double[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MultipleDoubleValues
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
