<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtractFirst StructType
 * @subpackage Structs
 */
class ExtractFirst extends AbstractStructBase
{
    /**
     * The document
     * @var \StructType\BusinessData
     */
    public $document;
    /**
     * The rules
     * @var \StructType\BusinessRules
     */
    public $rules;
    /**
     * The params
     * @var \StructType\ExtractionParameters
     */
    public $params;
    /**
     * Constructor method for ExtractFirst
     * @uses ExtractFirst::setDocument()
     * @uses ExtractFirst::setRules()
     * @uses ExtractFirst::setParams()
     * @param \StructType\BusinessData $document
     * @param \StructType\BusinessRules $rules
     * @param \StructType\ExtractionParameters $params
     */
    public function __construct(\StructType\BusinessData $document = null, \StructType\BusinessRules $rules = null, \StructType\ExtractionParameters $params = null)
    {
        $this
            ->setDocument($document)
            ->setRules($rules)
            ->setParams($params);
    }
    /**
     * Get document value
     * @return \StructType\BusinessData|null
     */
    public function getDocument()
    {
        return $this->document;
    }
    /**
     * Set document value
     * @param \StructType\BusinessData $document
     * @return \StructType\ExtractFirst
     */
    public function setDocument(\StructType\BusinessData $document = null)
    {
        $this->document = $document;
        return $this;
    }
    /**
     * Get rules value
     * @return \StructType\BusinessRules|null
     */
    public function getRules()
    {
        return $this->rules;
    }
    /**
     * Set rules value
     * @param \StructType\BusinessRules $rules
     * @return \StructType\ExtractFirst
     */
    public function setRules(\StructType\BusinessRules $rules = null)
    {
        $this->rules = $rules;
        return $this;
    }
    /**
     * Get params value
     * @return \StructType\ExtractionParameters|null
     */
    public function getParams()
    {
        return $this->params;
    }
    /**
     * Set params value
     * @param \StructType\ExtractionParameters $params
     * @return \StructType\ExtractFirst
     */
    public function setParams(\StructType\ExtractionParameters $params = null)
    {
        $this->params = $params;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExtractFirst
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
