<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConversionParameters StructType
 * @subpackage Structs
 */
class ConversionParameters extends AbstractStructBase
{
    /**
     * The inputType
     * @var string
     */
    public $inputType;
    /**
     * The outputType
     * @var string
     */
    public $outputType;
    /**
     * The customParameters
     * @var string
     */
    public $customParameters;
    /**
     * The outputFileMode
     * @var string
     */
    public $outputFileMode;
    /**
     * Constructor method for ConversionParameters
     * @uses ConversionParameters::setInputType()
     * @uses ConversionParameters::setOutputType()
     * @uses ConversionParameters::setCustomParameters()
     * @uses ConversionParameters::setOutputFileMode()
     * @param string $inputType
     * @param string $outputType
     * @param string $customParameters
     * @param string $outputFileMode
     */
    public function __construct($inputType = null, $outputType = null, $customParameters = null, $outputFileMode = null)
    {
        $this
            ->setInputType($inputType)
            ->setOutputType($outputType)
            ->setCustomParameters($customParameters)
            ->setOutputFileMode($outputFileMode);
    }
    /**
     * Get inputType value
     * @return string|null
     */
    public function getInputType()
    {
        return $this->inputType;
    }
    /**
     * Set inputType value
     * @param string $inputType
     * @return \StructType\ConversionParameters
     */
    public function setInputType($inputType = null)
    {
        // validation for constraint: string
        if (!is_null($inputType) && !is_string($inputType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inputType)), __LINE__);
        }
        $this->inputType = $inputType;
        return $this;
    }
    /**
     * Get outputType value
     * @return string|null
     */
    public function getOutputType()
    {
        return $this->outputType;
    }
    /**
     * Set outputType value
     * @param string $outputType
     * @return \StructType\ConversionParameters
     */
    public function setOutputType($outputType = null)
    {
        // validation for constraint: string
        if (!is_null($outputType) && !is_string($outputType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($outputType)), __LINE__);
        }
        $this->outputType = $outputType;
        return $this;
    }
    /**
     * Get customParameters value
     * @return string|null
     */
    public function getCustomParameters()
    {
        return $this->customParameters;
    }
    /**
     * Set customParameters value
     * @param string $customParameters
     * @return \StructType\ConversionParameters
     */
    public function setCustomParameters($customParameters = null)
    {
        // validation for constraint: string
        if (!is_null($customParameters) && !is_string($customParameters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customParameters)), __LINE__);
        }
        $this->customParameters = $customParameters;
        return $this;
    }
    /**
     * Get outputFileMode value
     * @return string|null
     */
    public function getOutputFileMode()
    {
        return $this->outputFileMode;
    }
    /**
     * Set outputFileMode value
     * @uses \EnumType\WSFILE_MODE::valueIsValid()
     * @uses \EnumType\WSFILE_MODE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outputFileMode
     * @return \StructType\ConversionParameters
     */
    public function setOutputFileMode($outputFileMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WSFILE_MODE::valueIsValid($outputFileMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $outputFileMode, implode(', ', \EnumType\WSFILE_MODE::getValidValues())), __LINE__);
        }
        $this->outputFileMode = $outputFileMode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConversionParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
