<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessData StructType
 * @subpackage Structs
 */
class BusinessData extends AbstractStructBase
{
    /**
     * The file
     * @var \StructType\WSFile
     */
    public $file;
    /**
     * The nExternalVars
     * @var int
     */
    public $nExternalVars;
    /**
     * The externalVars
     * Meta informations extracted from the WSDL
     * - SizeIs: nExternalVars
     * - nillable: true
     * @var \StructType\ExternalVars
     */
    public $externalVars;
    /**
     * The nAttachments
     * @var int
     */
    public $nAttachments;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - SizeIs: nAttachments
     * - nillable: true
     * @var \StructType\Attachments
     */
    public $attachments;
    /**
     * Constructor method for BusinessData
     * @uses BusinessData::setFile()
     * @uses BusinessData::setNExternalVars()
     * @uses BusinessData::setExternalVars()
     * @uses BusinessData::setNAttachments()
     * @uses BusinessData::setAttachments()
     * @param \StructType\WSFile $file
     * @param int $nExternalVars
     * @param \StructType\ExternalVars $externalVars
     * @param int $nAttachments
     * @param \StructType\Attachments $attachments
     */
    public function __construct(\StructType\WSFile $file = null, $nExternalVars = null, \StructType\ExternalVars $externalVars = null, $nAttachments = null, \StructType\Attachments $attachments = null)
    {
        $this
            ->setFile($file)
            ->setNExternalVars($nExternalVars)
            ->setExternalVars($externalVars)
            ->setNAttachments($nAttachments)
            ->setAttachments($attachments);
    }
    /**
     * Get file value
     * @return \StructType\WSFile|null
     */
    public function getFile()
    {
        return $this->file;
    }
    /**
     * Set file value
     * @param \StructType\WSFile $file
     * @return \StructType\BusinessData
     */
    public function setFile(\StructType\WSFile $file = null)
    {
        $this->file = $file;
        return $this;
    }
    /**
     * Get nExternalVars value
     * @return int|null
     */
    public function getNExternalVars()
    {
        return $this->nExternalVars;
    }
    /**
     * Set nExternalVars value
     * @param int $nExternalVars
     * @return \StructType\BusinessData
     */
    public function setNExternalVars($nExternalVars = null)
    {
        // validation for constraint: int
        if (!is_null($nExternalVars) && !is_numeric($nExternalVars)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nExternalVars)), __LINE__);
        }
        $this->nExternalVars = $nExternalVars;
        return $this;
    }
    /**
     * Get externalVars value
     * @return \StructType\ExternalVars|null
     */
    public function getExternalVars()
    {
        return $this->externalVars;
    }
    /**
     * Set externalVars value
     * @param \StructType\ExternalVars $externalVars
     * @return \StructType\BusinessData
     */
    public function setExternalVars(\StructType\ExternalVars $externalVars = null)
    {
        $this->externalVars = $externalVars;
        return $this;
    }
    /**
     * Get nAttachments value
     * @return int|null
     */
    public function getNAttachments()
    {
        return $this->nAttachments;
    }
    /**
     * Set nAttachments value
     * @param int $nAttachments
     * @return \StructType\BusinessData
     */
    public function setNAttachments($nAttachments = null)
    {
        // validation for constraint: int
        if (!is_null($nAttachments) && !is_numeric($nAttachments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nAttachments)), __LINE__);
        }
        $this->nAttachments = $nAttachments;
        return $this;
    }
    /**
     * Get attachments value
     * @return \StructType\Attachments|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @param \StructType\Attachments $attachments
     * @return \StructType\BusinessData
     */
    public function setAttachments(\StructType\Attachments $attachments = null)
    {
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusinessData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
