<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for List ServiceType
 * @subpackage Services
 */
class _List extends AbstractSoapClientBase
{
    /**
     * Sets the SessionHeaderValue SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\SessionHeader $sessionHeaderValue
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSessionHeaderValue(\StructType\SessionHeader $sessionHeaderValue, $nameSpace = 'urn:SubmissionService2', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SessionHeaderValue', $sessionHeaderValue, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ListResources
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeaderValue
     * - SOAPHeaderNamespaces: urn:SubmissionService2
     * - SOAPHeaderTypes: \StructType\SessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListResources $parameters
     * @return \StructType\ListResourcesResponse|bool
     */
    public function ListResources(\StructType\ListResources $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListResources($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ListResourcesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
