<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Submit ServiceType
 * @subpackage Services
 */
class Submit extends AbstractSoapClientBase
{
    /**
     * Sets the SessionHeaderValue SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\SessionHeader $sessionHeaderValue
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSessionHeaderValue(\StructType\SessionHeader $sessionHeaderValue, $nameSpace = 'urn:SubmissionService2', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SessionHeaderValue', $sessionHeaderValue, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Submit
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeaderValue
     * - SOAPHeaderNamespaces: urn:SubmissionService2
     * - SOAPHeaderTypes: \StructType\SessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit $parameters
     * @return \StructType\SubmitResponse|bool
     */
    public function Submit(\StructType\Submit $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Submit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubmitTransport
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeaderValue
     * - SOAPHeaderNamespaces: urn:SubmissionService2
     * - SOAPHeaderTypes: \StructType\SessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SubmitTransport $parameters
     * @return \StructType\SubmitTransportResponse|bool
     */
    public function SubmitTransport(\StructType\SubmitTransport $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SubmitTransport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubmitXML
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeaderValue
     * - SOAPHeaderNamespaces: urn:SubmissionService2
     * - SOAPHeaderTypes: \StructType\SessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SubmitXML $parameters
     * @return \StructType\SubmitXMLResponse|bool
     */
    public function SubmitXML(\StructType\SubmitXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SubmitXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SubmitResponse|\StructType\SubmitTransportResponse|\StructType\SubmitXMLResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
