<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Extract ServiceType
 * @subpackage Services
 */
class Extract extends AbstractSoapClientBase
{
    /**
     * Sets the SessionHeaderValue SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\SessionHeader $sessionHeaderValue
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSessionHeaderValue(\StructType\SessionHeader $sessionHeaderValue, $nameSpace = 'urn:SubmissionService2', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SessionHeaderValue', $sessionHeaderValue, $mustUnderstand, $actor);
    }
    /**
     * Sets the ExtractionHeaderValue SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ExtractionHeader $extractionHeaderValue
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderExtractionHeaderValue(\StructType\ExtractionHeader $extractionHeaderValue, $nameSpace = 'urn:SubmissionService2', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ExtractionHeaderValue', $extractionHeaderValue, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ExtractFirst
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeaderValue
     * - SOAPHeaderNamespaces: urn:SubmissionService2
     * - SOAPHeaderTypes: \StructType\SessionHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExtractFirst $parameters
     * @return \StructType\ExtractFirstResponse|bool
     */
    public function ExtractFirst(\StructType\ExtractFirst $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExtractFirst($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExtractNext
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeaderValue, ExtractionHeaderValue
     * - SOAPHeaderNamespaces: urn:SubmissionService2, urn:SubmissionService2
     * - SOAPHeaderTypes: \StructType\SessionHeader, \StructType\ExtractionHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExtractNext $parameters
     * @return \StructType\ExtractNextResponse|bool
     */
    public function ExtractNext(\StructType\ExtractNext $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExtractNext($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ExtractFirstResponse|\StructType\ExtractNextResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
