<?php

namespace EnumType;

/**
 * This class stands for WSFILE_MODE EnumType
 * @subpackage Enumerations
 */
class WSFILE_MODE
{
    /**
     * Constant for value 'MODE_UNDEFINED'
     * @return string 'MODE_UNDEFINED'
     */
    const VALUE_MODE_UNDEFINED = 'MODE_UNDEFINED';
    /**
     * Constant for value 'MODE_ON_SERVER'
     * @return string 'MODE_ON_SERVER'
     */
    const VALUE_MODE_ON_SERVER = 'MODE_ON_SERVER';
    /**
     * Constant for value 'MODE_INLINED'
     * @return string 'MODE_INLINED'
     */
    const VALUE_MODE_INLINED = 'MODE_INLINED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MODE_UNDEFINED
     * @uses self::VALUE_MODE_ON_SERVER
     * @uses self::VALUE_MODE_INLINED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MODE_UNDEFINED,
            self::VALUE_MODE_ON_SERVER,
            self::VALUE_MODE_INLINED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
