<?php

namespace EnumType;

/**
 * This class stands for RESOURCE_TYPE EnumType
 * @subpackage Enumerations
 */
class RESOURCE_TYPE
{
    /**
     * Constant for value 'TYPE_SALESFORCE_LEAD_EMAILBODY'
     * @return string 'TYPE_SALESFORCE_LEAD_EMAILBODY'
     */
    const VALUE_TYPE_SALESFORCE_LEAD_EMAILBODY = 'TYPE_SALESFORCE_LEAD_EMAILBODY';
    /**
     * Constant for value 'TYPE_SALESFORCE_LEAD_FAXCOVER'
     * @return string 'TYPE_SALESFORCE_LEAD_FAXCOVER'
     */
    const VALUE_TYPE_SALESFORCE_LEAD_FAXCOVER = 'TYPE_SALESFORCE_LEAD_FAXCOVER';
    /**
     * Constant for value 'TYPE_SALESFORCE_CONTACT_EMAILBODY'
     * @return string 'TYPE_SALESFORCE_CONTACT_EMAILBODY'
     */
    const VALUE_TYPE_SALESFORCE_CONTACT_EMAILBODY = 'TYPE_SALESFORCE_CONTACT_EMAILBODY';
    /**
     * Constant for value 'TYPE_SALESFORCE_CONTACT_FAXCOVER'
     * @return string 'TYPE_SALESFORCE_CONTACT_FAXCOVER'
     */
    const VALUE_TYPE_SALESFORCE_CONTACT_FAXCOVER = 'TYPE_SALESFORCE_CONTACT_FAXCOVER';
    /**
     * Constant for value 'TYPE_SALESFORCE_SETTINGS'
     * @return string 'TYPE_SALESFORCE_SETTINGS'
     */
    const VALUE_TYPE_SALESFORCE_SETTINGS = 'TYPE_SALESFORCE_SETTINGS';
    /**
     * Constant for value 'TYPE_STYLESHEET'
     * @return string 'TYPE_STYLESHEET'
     */
    const VALUE_TYPE_STYLESHEET = 'TYPE_STYLESHEET';
    /**
     * Constant for value 'TYPE_IMAGE'
     * @return string 'TYPE_IMAGE'
     */
    const VALUE_TYPE_IMAGE = 'TYPE_IMAGE';
    /**
     * Constant for value 'TYPE_COVER'
     * @return string 'TYPE_COVER'
     */
    const VALUE_TYPE_COVER = 'TYPE_COVER';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TYPE_SALESFORCE_LEAD_EMAILBODY
     * @uses self::VALUE_TYPE_SALESFORCE_LEAD_FAXCOVER
     * @uses self::VALUE_TYPE_SALESFORCE_CONTACT_EMAILBODY
     * @uses self::VALUE_TYPE_SALESFORCE_CONTACT_FAXCOVER
     * @uses self::VALUE_TYPE_SALESFORCE_SETTINGS
     * @uses self::VALUE_TYPE_STYLESHEET
     * @uses self::VALUE_TYPE_IMAGE
     * @uses self::VALUE_TYPE_COVER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TYPE_SALESFORCE_LEAD_EMAILBODY,
            self::VALUE_TYPE_SALESFORCE_LEAD_FAXCOVER,
            self::VALUE_TYPE_SALESFORCE_CONTACT_EMAILBODY,
            self::VALUE_TYPE_SALESFORCE_CONTACT_FAXCOVER,
            self::VALUE_TYPE_SALESFORCE_SETTINGS,
            self::VALUE_TYPE_STYLESHEET,
            self::VALUE_TYPE_IMAGE,
            self::VALUE_TYPE_COVER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
