<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for store_item_inventory StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:store_item_inventory
 * @subpackage Structs
 */
class Store_item_inventory extends AbstractStructBase
{
    /**
     * The SKU
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SKU;
    /**
     * The flag
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $flag;
    /**
     * The in_bound_stock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $in_bound_stock;
    /**
     * The on_hand_stock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $on_hand_stock;
    /**
     * The reserved_stock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $reserved_stock;
    /**
     * Constructor method for store_item_inventory
     * @uses Store_item_inventory::setSKU()
     * @uses Store_item_inventory::setFlag()
     * @uses Store_item_inventory::setIn_bound_stock()
     * @uses Store_item_inventory::setOn_hand_stock()
     * @uses Store_item_inventory::setReserved_stock()
     * @param string $sKU
     * @param string $flag
     * @param float $in_bound_stock
     * @param float $on_hand_stock
     * @param float $reserved_stock
     */
    public function __construct($sKU = null, $flag = null, $in_bound_stock = null, $on_hand_stock = null, $reserved_stock = null)
    {
        $this
            ->setSKU($sKU)
            ->setFlag($flag)
            ->setIn_bound_stock($in_bound_stock)
            ->setOn_hand_stock($on_hand_stock)
            ->setReserved_stock($reserved_stock);
    }
    /**
     * Get SKU value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSKU()
    {
        return isset($this->SKU) ? $this->SKU : null;
    }
    /**
     * Set SKU value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sKU
     * @return \StructType\Store_item_inventory
     */
    public function setSKU($sKU = null)
    {
        // validation for constraint: string
        if (!is_null($sKU) && !is_string($sKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sKU)), __LINE__);
        }
        if (is_null($sKU) || (is_array($sKU) && empty($sKU))) {
            unset($this->SKU);
        } else {
            $this->SKU = $sKU;
        }
        return $this;
    }
    /**
     * Get flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlag()
    {
        return isset($this->flag) ? $this->flag : null;
    }
    /**
     * Set flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flag
     * @return \StructType\Store_item_inventory
     */
    public function setFlag($flag = null)
    {
        // validation for constraint: string
        if (!is_null($flag) && !is_string($flag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flag)), __LINE__);
        }
        if (is_null($flag) || (is_array($flag) && empty($flag))) {
            unset($this->flag);
        } else {
            $this->flag = $flag;
        }
        return $this;
    }
    /**
     * Get in_bound_stock value
     * @return float|null
     */
    public function getIn_bound_stock()
    {
        return $this->in_bound_stock;
    }
    /**
     * Set in_bound_stock value
     * @param float $in_bound_stock
     * @return \StructType\Store_item_inventory
     */
    public function setIn_bound_stock($in_bound_stock = null)
    {
        $this->in_bound_stock = $in_bound_stock;
        return $this;
    }
    /**
     * Get on_hand_stock value
     * @return float|null
     */
    public function getOn_hand_stock()
    {
        return $this->on_hand_stock;
    }
    /**
     * Set on_hand_stock value
     * @param float $on_hand_stock
     * @return \StructType\Store_item_inventory
     */
    public function setOn_hand_stock($on_hand_stock = null)
    {
        $this->on_hand_stock = $on_hand_stock;
        return $this;
    }
    /**
     * Get reserved_stock value
     * @return float|null
     */
    public function getReserved_stock()
    {
        return $this->reserved_stock;
    }
    /**
     * Set reserved_stock value
     * @param float $reserved_stock
     * @return \StructType\Store_item_inventory
     */
    public function setReserved_stock($reserved_stock = null)
    {
        $this->reserved_stock = $reserved_stock;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Store_item_inventory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
