<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for store_item StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:store_item
 * @subpackage Structs
 */
class Store_item extends AbstractStructBase
{
    /**
     * The SKU
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SKU;
    /**
     * The desired_stock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $desired_stock;
    /**
     * The flag
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $flag;
    /**
     * The max_stock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $max_stock;
    /**
     * The min_stock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $min_stock;
    /**
     * The priority
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $priority;
    /**
     * The store
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $store;
    /**
     * Constructor method for store_item
     * @uses Store_item::setSKU()
     * @uses Store_item::setDesired_stock()
     * @uses Store_item::setFlag()
     * @uses Store_item::setMax_stock()
     * @uses Store_item::setMin_stock()
     * @uses Store_item::setPriority()
     * @uses Store_item::setStore()
     * @param string $sKU
     * @param float $desired_stock
     * @param string $flag
     * @param float $max_stock
     * @param float $min_stock
     * @param float $priority
     * @param string $store
     */
    public function __construct($sKU = null, $desired_stock = null, $flag = null, $max_stock = null, $min_stock = null, $priority = null, $store = null)
    {
        $this
            ->setSKU($sKU)
            ->setDesired_stock($desired_stock)
            ->setFlag($flag)
            ->setMax_stock($max_stock)
            ->setMin_stock($min_stock)
            ->setPriority($priority)
            ->setStore($store);
    }
    /**
     * Get SKU value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSKU()
    {
        return isset($this->SKU) ? $this->SKU : null;
    }
    /**
     * Set SKU value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sKU
     * @return \StructType\Store_item
     */
    public function setSKU($sKU = null)
    {
        // validation for constraint: string
        if (!is_null($sKU) && !is_string($sKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sKU)), __LINE__);
        }
        if (is_null($sKU) || (is_array($sKU) && empty($sKU))) {
            unset($this->SKU);
        } else {
            $this->SKU = $sKU;
        }
        return $this;
    }
    /**
     * Get desired_stock value
     * @return float|null
     */
    public function getDesired_stock()
    {
        return $this->desired_stock;
    }
    /**
     * Set desired_stock value
     * @param float $desired_stock
     * @return \StructType\Store_item
     */
    public function setDesired_stock($desired_stock = null)
    {
        $this->desired_stock = $desired_stock;
        return $this;
    }
    /**
     * Get flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlag()
    {
        return isset($this->flag) ? $this->flag : null;
    }
    /**
     * Set flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flag
     * @return \StructType\Store_item
     */
    public function setFlag($flag = null)
    {
        // validation for constraint: string
        if (!is_null($flag) && !is_string($flag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flag)), __LINE__);
        }
        if (is_null($flag) || (is_array($flag) && empty($flag))) {
            unset($this->flag);
        } else {
            $this->flag = $flag;
        }
        return $this;
    }
    /**
     * Get max_stock value
     * @return float|null
     */
    public function getMax_stock()
    {
        return $this->max_stock;
    }
    /**
     * Set max_stock value
     * @param float $max_stock
     * @return \StructType\Store_item
     */
    public function setMax_stock($max_stock = null)
    {
        $this->max_stock = $max_stock;
        return $this;
    }
    /**
     * Get min_stock value
     * @return float|null
     */
    public function getMin_stock()
    {
        return $this->min_stock;
    }
    /**
     * Set min_stock value
     * @param float $min_stock
     * @return \StructType\Store_item
     */
    public function setMin_stock($min_stock = null)
    {
        $this->min_stock = $min_stock;
        return $this;
    }
    /**
     * Get priority value
     * @return float|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @param float $priority
     * @return \StructType\Store_item
     */
    public function setPriority($priority = null)
    {
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get store value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStore()
    {
        return isset($this->store) ? $this->store : null;
    }
    /**
     * Set store value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $store
     * @return \StructType\Store_item
     */
    public function setStore($store = null)
    {
        // validation for constraint: string
        if (!is_null($store) && !is_string($store)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store)), __LINE__);
        }
        if (is_null($store) || (is_array($store) && empty($store))) {
            unset($this->store);
        } else {
            $this->store = $store;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Store_item
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
