<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoice_information StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Invoice_information
 * @subpackage Structs
 */
class Invoice_information extends AbstractStructBase
{
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Currency;
    /**
     * The Customer_PO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Customer_PO;
    /**
     * The Invoice_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Invoice_ID;
    /**
     * The Invoice_cust
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Invoice_cust;
    /**
     * The Invoice_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_date;
    /**
     * The Pay_term
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Pay_term;
    /**
     * The Total_Amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Total_Amount;
    /**
     * The invoice_lines
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfinvoice_line
     */
    public $invoice_lines;
    /**
     * The pdf_invoice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pdf_invoice;
    /**
     * Constructor method for Invoice_information
     * @uses Invoice_information::setCurrency()
     * @uses Invoice_information::setCustomer_PO()
     * @uses Invoice_information::setInvoice_ID()
     * @uses Invoice_information::setInvoice_cust()
     * @uses Invoice_information::setInvoice_date()
     * @uses Invoice_information::setPay_term()
     * @uses Invoice_information::setTotal_Amount()
     * @uses Invoice_information::setInvoice_lines()
     * @uses Invoice_information::setPdf_invoice()
     * @param string $currency
     * @param string $customer_PO
     * @param string $invoice_ID
     * @param string $invoice_cust
     * @param string $invoice_date
     * @param int $pay_term
     * @param float $total_Amount
     * @param \ArrayType\ArrayOfinvoice_line $invoice_lines
     * @param string $pdf_invoice
     */
    public function __construct($currency = null, $customer_PO = null, $invoice_ID = null, $invoice_cust = null, $invoice_date = null, $pay_term = null, $total_Amount = null, \ArrayType\ArrayOfinvoice_line $invoice_lines = null, $pdf_invoice = null)
    {
        $this
            ->setCurrency($currency)
            ->setCustomer_PO($customer_PO)
            ->setInvoice_ID($invoice_ID)
            ->setInvoice_cust($invoice_cust)
            ->setInvoice_date($invoice_date)
            ->setPay_term($pay_term)
            ->setTotal_Amount($total_Amount)
            ->setInvoice_lines($invoice_lines)
            ->setPdf_invoice($pdf_invoice);
    }
    /**
     * Get Currency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrency()
    {
        return isset($this->Currency) ? $this->Currency : null;
    }
    /**
     * Set Currency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currency
     * @return \StructType\Invoice_information
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        if (is_null($currency) || (is_array($currency) && empty($currency))) {
            unset($this->Currency);
        } else {
            $this->Currency = $currency;
        }
        return $this;
    }
    /**
     * Get Customer_PO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomer_PO()
    {
        return isset($this->Customer_PO) ? $this->Customer_PO : null;
    }
    /**
     * Set Customer_PO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customer_PO
     * @return \StructType\Invoice_information
     */
    public function setCustomer_PO($customer_PO = null)
    {
        // validation for constraint: string
        if (!is_null($customer_PO) && !is_string($customer_PO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_PO)), __LINE__);
        }
        if (is_null($customer_PO) || (is_array($customer_PO) && empty($customer_PO))) {
            unset($this->Customer_PO);
        } else {
            $this->Customer_PO = $customer_PO;
        }
        return $this;
    }
    /**
     * Get Invoice_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoice_ID()
    {
        return isset($this->Invoice_ID) ? $this->Invoice_ID : null;
    }
    /**
     * Set Invoice_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoice_ID
     * @return \StructType\Invoice_information
     */
    public function setInvoice_ID($invoice_ID = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_ID) && !is_string($invoice_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoice_ID)), __LINE__);
        }
        if (is_null($invoice_ID) || (is_array($invoice_ID) && empty($invoice_ID))) {
            unset($this->Invoice_ID);
        } else {
            $this->Invoice_ID = $invoice_ID;
        }
        return $this;
    }
    /**
     * Get Invoice_cust value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoice_cust()
    {
        return isset($this->Invoice_cust) ? $this->Invoice_cust : null;
    }
    /**
     * Set Invoice_cust value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoice_cust
     * @return \StructType\Invoice_information
     */
    public function setInvoice_cust($invoice_cust = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_cust) && !is_string($invoice_cust)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoice_cust)), __LINE__);
        }
        if (is_null($invoice_cust) || (is_array($invoice_cust) && empty($invoice_cust))) {
            unset($this->Invoice_cust);
        } else {
            $this->Invoice_cust = $invoice_cust;
        }
        return $this;
    }
    /**
     * Get Invoice_date value
     * @return string|null
     */
    public function getInvoice_date()
    {
        return $this->Invoice_date;
    }
    /**
     * Set Invoice_date value
     * @param string $invoice_date
     * @return \StructType\Invoice_information
     */
    public function setInvoice_date($invoice_date = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_date) && !is_string($invoice_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoice_date)), __LINE__);
        }
        $this->Invoice_date = $invoice_date;
        return $this;
    }
    /**
     * Get Pay_term value
     * @return int|null
     */
    public function getPay_term()
    {
        return $this->Pay_term;
    }
    /**
     * Set Pay_term value
     * @param int $pay_term
     * @return \StructType\Invoice_information
     */
    public function setPay_term($pay_term = null)
    {
        // validation for constraint: int
        if (!is_null($pay_term) && !is_numeric($pay_term)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pay_term)), __LINE__);
        }
        $this->Pay_term = $pay_term;
        return $this;
    }
    /**
     * Get Total_Amount value
     * @return float|null
     */
    public function getTotal_Amount()
    {
        return $this->Total_Amount;
    }
    /**
     * Set Total_Amount value
     * @param float $total_Amount
     * @return \StructType\Invoice_information
     */
    public function setTotal_Amount($total_Amount = null)
    {
        $this->Total_Amount = $total_Amount;
        return $this;
    }
    /**
     * Get invoice_lines value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfinvoice_line|null
     */
    public function getInvoice_lines()
    {
        return isset($this->invoice_lines) ? $this->invoice_lines : null;
    }
    /**
     * Set invoice_lines value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfinvoice_line $invoice_lines
     * @return \StructType\Invoice_information
     */
    public function setInvoice_lines(\ArrayType\ArrayOfinvoice_line $invoice_lines = null)
    {
        if (is_null($invoice_lines) || (is_array($invoice_lines) && empty($invoice_lines))) {
            unset($this->invoice_lines);
        } else {
            $this->invoice_lines = $invoice_lines;
        }
        return $this;
    }
    /**
     * Get pdf_invoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPdf_invoice()
    {
        return isset($this->pdf_invoice) ? $this->pdf_invoice : null;
    }
    /**
     * Set pdf_invoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pdf_invoice
     * @return \StructType\Invoice_information
     */
    public function setPdf_invoice($pdf_invoice = null)
    {
        // validation for constraint: string
        if (!is_null($pdf_invoice) && !is_string($pdf_invoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pdf_invoice)), __LINE__);
        }
        if (is_null($pdf_invoice) || (is_array($pdf_invoice) && empty($pdf_invoice))) {
            unset($this->pdf_invoice);
        } else {
            $this->pdf_invoice = $pdf_invoice;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Invoice_information
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
