<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfrsiq_options ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfrsiq_options
 * @subpackage Arrays
 */
class ArrayOfrsiq_options extends AbstractStructArrayBase
{
    /**
     * The rsiq_options
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Rsiq_options[]
     */
    public $rsiq_options;
    /**
     * Constructor method for ArrayOfrsiq_options
     * @uses ArrayOfrsiq_options::setRsiq_options()
     * @param \StructType\Rsiq_options[] $rsiq_options
     */
    public function __construct(array $rsiq_options = array())
    {
        $this
            ->setRsiq_options($rsiq_options);
    }
    /**
     * Get rsiq_options value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Rsiq_options[]|null
     */
    public function getRsiq_options()
    {
        return isset($this->rsiq_options) ? $this->rsiq_options : null;
    }
    /**
     * Set rsiq_options value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Rsiq_options[] $rsiq_options
     * @return \ArrayType\ArrayOfrsiq_options
     */
    public function setRsiq_options(array $rsiq_options = array())
    {
        foreach ($rsiq_options as $arrayOfrsiq_optionsRsiq_optionsItem) {
            // validation for constraint: itemType
            if (!$arrayOfrsiq_optionsRsiq_optionsItem instanceof \StructType\Rsiq_options) {
                throw new \InvalidArgumentException(sprintf('The rsiq_options property can only contain items of \StructType\Rsiq_options, "%s" given', is_object($arrayOfrsiq_optionsRsiq_optionsItem) ? get_class($arrayOfrsiq_optionsRsiq_optionsItem) : gettype($arrayOfrsiq_optionsRsiq_optionsItem)), __LINE__);
            }
        }
        if (is_null($rsiq_options) || (is_array($rsiq_options) && empty($rsiq_options))) {
            unset($this->rsiq_options);
        } else {
            $this->rsiq_options = $rsiq_options;
        }
        return $this;
    }
    /**
     * Add item to rsiq_options value
     * @throws \InvalidArgumentException
     * @param \StructType\Rsiq_options $item
     * @return \ArrayType\ArrayOfrsiq_options
     */
    public function addToRsiq_options(\StructType\Rsiq_options $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Rsiq_options) {
            throw new \InvalidArgumentException(sprintf('The rsiq_options property can only contain items of \StructType\Rsiq_options, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->rsiq_options[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Rsiq_options|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Rsiq_options|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Rsiq_options|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Rsiq_options|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Rsiq_options|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string rsiq_options
     */
    public function getAttributeName()
    {
        return 'rsiq_options';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfrsiq_options
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
