<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfStore_Allocation_Items ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfStore_Allocation_Items
 * @subpackage Arrays
 */
class ArrayOfStore_Allocation_Items extends AbstractStructArrayBase
{
    /**
     * The Store_Allocation_Items
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Store_Allocation_Items[]
     */
    public $Store_Allocation_Items;
    /**
     * Constructor method for ArrayOfStore_Allocation_Items
     * @uses ArrayOfStore_Allocation_Items::setStore_Allocation_Items()
     * @param \StructType\Store_Allocation_Items[] $store_Allocation_Items
     */
    public function __construct(array $store_Allocation_Items = array())
    {
        $this
            ->setStore_Allocation_Items($store_Allocation_Items);
    }
    /**
     * Get Store_Allocation_Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Store_Allocation_Items[]|null
     */
    public function getStore_Allocation_Items()
    {
        return isset($this->Store_Allocation_Items) ? $this->Store_Allocation_Items : null;
    }
    /**
     * Set Store_Allocation_Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Store_Allocation_Items[] $store_Allocation_Items
     * @return \ArrayType\ArrayOfStore_Allocation_Items
     */
    public function setStore_Allocation_Items(array $store_Allocation_Items = array())
    {
        foreach ($store_Allocation_Items as $arrayOfStore_Allocation_ItemsStore_Allocation_ItemsItem) {
            // validation for constraint: itemType
            if (!$arrayOfStore_Allocation_ItemsStore_Allocation_ItemsItem instanceof \StructType\Store_Allocation_Items) {
                throw new \InvalidArgumentException(sprintf('The Store_Allocation_Items property can only contain items of \StructType\Store_Allocation_Items, "%s" given', is_object($arrayOfStore_Allocation_ItemsStore_Allocation_ItemsItem) ? get_class($arrayOfStore_Allocation_ItemsStore_Allocation_ItemsItem) : gettype($arrayOfStore_Allocation_ItemsStore_Allocation_ItemsItem)), __LINE__);
            }
        }
        if (is_null($store_Allocation_Items) || (is_array($store_Allocation_Items) && empty($store_Allocation_Items))) {
            unset($this->Store_Allocation_Items);
        } else {
            $this->Store_Allocation_Items = $store_Allocation_Items;
        }
        return $this;
    }
    /**
     * Add item to Store_Allocation_Items value
     * @throws \InvalidArgumentException
     * @param \StructType\Store_Allocation_Items $item
     * @return \ArrayType\ArrayOfStore_Allocation_Items
     */
    public function addToStore_Allocation_Items(\StructType\Store_Allocation_Items $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Store_Allocation_Items) {
            throw new \InvalidArgumentException(sprintf('The Store_Allocation_Items property can only contain items of \StructType\Store_Allocation_Items, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Store_Allocation_Items[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Store_Allocation_Items|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Store_Allocation_Items|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Store_Allocation_Items|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Store_Allocation_Items|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Store_Allocation_Items|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Store_Allocation_Items
     */
    public function getAttributeName()
    {
        return 'Store_Allocation_Items';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfStore_Allocation_Items
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
