<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Store_Allocation_Items StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Store_Allocation_Items
 * @subpackage Structs
 */
class Store_Allocation_Items extends AbstractStructBase
{
    /**
     * The SKU
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SKU;
    /**
     * The desired_stock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $desired_stock;
    /**
     * The in_bound_stock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $in_bound_stock;
    /**
     * The max_stock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $max_stock;
    /**
     * The min_stock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $min_stock;
    /**
     * The on_hand_stock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $on_hand_stock;
    /**
     * The priority
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $priority;
    /**
     * The proposed_allocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $proposed_allocation;
    /**
     * The reserved_stock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $reserved_stock;
    /**
     * The store
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $store;
    /**
     * Constructor method for Store_Allocation_Items
     * @uses Store_Allocation_Items::setSKU()
     * @uses Store_Allocation_Items::setDesired_stock()
     * @uses Store_Allocation_Items::setIn_bound_stock()
     * @uses Store_Allocation_Items::setMax_stock()
     * @uses Store_Allocation_Items::setMin_stock()
     * @uses Store_Allocation_Items::setOn_hand_stock()
     * @uses Store_Allocation_Items::setPriority()
     * @uses Store_Allocation_Items::setProposed_allocation()
     * @uses Store_Allocation_Items::setReserved_stock()
     * @uses Store_Allocation_Items::setStore()
     * @param string $sKU
     * @param float $desired_stock
     * @param float $in_bound_stock
     * @param float $max_stock
     * @param float $min_stock
     * @param float $on_hand_stock
     * @param float $priority
     * @param float $proposed_allocation
     * @param float $reserved_stock
     * @param string $store
     */
    public function __construct($sKU = null, $desired_stock = null, $in_bound_stock = null, $max_stock = null, $min_stock = null, $on_hand_stock = null, $priority = null, $proposed_allocation = null, $reserved_stock = null, $store = null)
    {
        $this
            ->setSKU($sKU)
            ->setDesired_stock($desired_stock)
            ->setIn_bound_stock($in_bound_stock)
            ->setMax_stock($max_stock)
            ->setMin_stock($min_stock)
            ->setOn_hand_stock($on_hand_stock)
            ->setPriority($priority)
            ->setProposed_allocation($proposed_allocation)
            ->setReserved_stock($reserved_stock)
            ->setStore($store);
    }
    /**
     * Get SKU value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSKU()
    {
        return isset($this->SKU) ? $this->SKU : null;
    }
    /**
     * Set SKU value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sKU
     * @return \StructType\Store_Allocation_Items
     */
    public function setSKU($sKU = null)
    {
        // validation for constraint: string
        if (!is_null($sKU) && !is_string($sKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sKU)), __LINE__);
        }
        if (is_null($sKU) || (is_array($sKU) && empty($sKU))) {
            unset($this->SKU);
        } else {
            $this->SKU = $sKU;
        }
        return $this;
    }
    /**
     * Get desired_stock value
     * @return float|null
     */
    public function getDesired_stock()
    {
        return $this->desired_stock;
    }
    /**
     * Set desired_stock value
     * @param float $desired_stock
     * @return \StructType\Store_Allocation_Items
     */
    public function setDesired_stock($desired_stock = null)
    {
        $this->desired_stock = $desired_stock;
        return $this;
    }
    /**
     * Get in_bound_stock value
     * @return float|null
     */
    public function getIn_bound_stock()
    {
        return $this->in_bound_stock;
    }
    /**
     * Set in_bound_stock value
     * @param float $in_bound_stock
     * @return \StructType\Store_Allocation_Items
     */
    public function setIn_bound_stock($in_bound_stock = null)
    {
        $this->in_bound_stock = $in_bound_stock;
        return $this;
    }
    /**
     * Get max_stock value
     * @return float|null
     */
    public function getMax_stock()
    {
        return $this->max_stock;
    }
    /**
     * Set max_stock value
     * @param float $max_stock
     * @return \StructType\Store_Allocation_Items
     */
    public function setMax_stock($max_stock = null)
    {
        $this->max_stock = $max_stock;
        return $this;
    }
    /**
     * Get min_stock value
     * @return float|null
     */
    public function getMin_stock()
    {
        return $this->min_stock;
    }
    /**
     * Set min_stock value
     * @param float $min_stock
     * @return \StructType\Store_Allocation_Items
     */
    public function setMin_stock($min_stock = null)
    {
        $this->min_stock = $min_stock;
        return $this;
    }
    /**
     * Get on_hand_stock value
     * @return float|null
     */
    public function getOn_hand_stock()
    {
        return $this->on_hand_stock;
    }
    /**
     * Set on_hand_stock value
     * @param float $on_hand_stock
     * @return \StructType\Store_Allocation_Items
     */
    public function setOn_hand_stock($on_hand_stock = null)
    {
        $this->on_hand_stock = $on_hand_stock;
        return $this;
    }
    /**
     * Get priority value
     * @return float|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @param float $priority
     * @return \StructType\Store_Allocation_Items
     */
    public function setPriority($priority = null)
    {
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get proposed_allocation value
     * @return float|null
     */
    public function getProposed_allocation()
    {
        return $this->proposed_allocation;
    }
    /**
     * Set proposed_allocation value
     * @param float $proposed_allocation
     * @return \StructType\Store_Allocation_Items
     */
    public function setProposed_allocation($proposed_allocation = null)
    {
        $this->proposed_allocation = $proposed_allocation;
        return $this;
    }
    /**
     * Get reserved_stock value
     * @return float|null
     */
    public function getReserved_stock()
    {
        return $this->reserved_stock;
    }
    /**
     * Set reserved_stock value
     * @param float $reserved_stock
     * @return \StructType\Store_Allocation_Items
     */
    public function setReserved_stock($reserved_stock = null)
    {
        $this->reserved_stock = $reserved_stock;
        return $this;
    }
    /**
     * Get store value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStore()
    {
        return isset($this->store) ? $this->store : null;
    }
    /**
     * Set store value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $store
     * @return \StructType\Store_Allocation_Items
     */
    public function setStore($store = null)
    {
        // validation for constraint: string
        if (!is_null($store) && !is_string($store)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store)), __LINE__);
        }
        if (is_null($store) || (is_array($store) && empty($store))) {
            unset($this->store);
        } else {
            $this->store = $store;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Store_Allocation_Items
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
