<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSIQRequestResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RSIQRequestResponse
 * @subpackage Structs
 */
class RSIQRequestResponse extends AbstractStructBase
{
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $status;
    /**
     * The store_values
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfStore_Allocation_Items
     */
    public $store_values;
    /**
     * Constructor method for RSIQRequestResponse
     * @uses RSIQRequestResponse::setStatus()
     * @uses RSIQRequestResponse::setStore_values()
     * @param string $status
     * @param \ArrayType\ArrayOfStore_Allocation_Items $store_values
     */
    public function __construct($status = null, \ArrayType\ArrayOfStore_Allocation_Items $store_values = null)
    {
        $this
            ->setStatus($status)
            ->setStore_values($store_values);
    }
    /**
     * Get status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : null;
    }
    /**
     * Set status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \StructType\RSIQRequestResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->status);
        } else {
            $this->status = $status;
        }
        return $this;
    }
    /**
     * Get store_values value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfStore_Allocation_Items|null
     */
    public function getStore_values()
    {
        return isset($this->store_values) ? $this->store_values : null;
    }
    /**
     * Set store_values value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfStore_Allocation_Items $store_values
     * @return \StructType\RSIQRequestResponse
     */
    public function setStore_values(\ArrayType\ArrayOfStore_Allocation_Items $store_values = null)
    {
        if (is_null($store_values) || (is_array($store_values) && empty($store_values))) {
            unset($this->store_values);
        } else {
            $this->store_values = $store_values;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RSIQRequestResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
