<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NewShipmentRequestResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:NewShipmentRequestResponse
 * @subpackage Structs
 */
class NewShipmentRequestResponse extends AbstractStructBase
{
    /**
     * The shipments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfshipment_status
     */
    public $shipments;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $status;
    /**
     * Constructor method for NewShipmentRequestResponse
     * @uses NewShipmentRequestResponse::setShipments()
     * @uses NewShipmentRequestResponse::setStatus()
     * @param \ArrayType\ArrayOfshipment_status $shipments
     * @param string $status
     */
    public function __construct(\ArrayType\ArrayOfshipment_status $shipments = null, $status = null)
    {
        $this
            ->setShipments($shipments)
            ->setStatus($status);
    }
    /**
     * Get shipments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfshipment_status|null
     */
    public function getShipments()
    {
        return isset($this->shipments) ? $this->shipments : null;
    }
    /**
     * Set shipments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfshipment_status $shipments
     * @return \StructType\NewShipmentRequestResponse
     */
    public function setShipments(\ArrayType\ArrayOfshipment_status $shipments = null)
    {
        if (is_null($shipments) || (is_array($shipments) && empty($shipments))) {
            unset($this->shipments);
        } else {
            $this->shipments = $shipments;
        }
        return $this;
    }
    /**
     * Get status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : null;
    }
    /**
     * Set status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \StructType\NewShipmentRequestResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->status);
        } else {
            $this->status = $status;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NewShipmentRequestResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
