<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Importinvoice ServiceType
 * @subpackage Services
 */
class Importinvoice extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named import_invoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Import_invoice $parameters
     * @return \StructType\Import_invoiceResponse|bool
     */
    public function import_invoice(\StructType\Import_invoice $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->import_invoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Import_invoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
