<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfstore_item_sales ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfstore_item_sales
 * @subpackage Arrays
 */
class ArrayOfstore_item_sales extends AbstractStructArrayBase
{
    /**
     * The store_item_sales
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Store_item_sales[]
     */
    public $store_item_sales;
    /**
     * Constructor method for ArrayOfstore_item_sales
     * @uses ArrayOfstore_item_sales::setStore_item_sales()
     * @param \StructType\Store_item_sales[] $store_item_sales
     */
    public function __construct(array $store_item_sales = array())
    {
        $this
            ->setStore_item_sales($store_item_sales);
    }
    /**
     * Get store_item_sales value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Store_item_sales[]|null
     */
    public function getStore_item_sales()
    {
        return isset($this->store_item_sales) ? $this->store_item_sales : null;
    }
    /**
     * Set store_item_sales value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Store_item_sales[] $store_item_sales
     * @return \ArrayType\ArrayOfstore_item_sales
     */
    public function setStore_item_sales(array $store_item_sales = array())
    {
        foreach ($store_item_sales as $arrayOfstore_item_salesStore_item_salesItem) {
            // validation for constraint: itemType
            if (!$arrayOfstore_item_salesStore_item_salesItem instanceof \StructType\Store_item_sales) {
                throw new \InvalidArgumentException(sprintf('The store_item_sales property can only contain items of \StructType\Store_item_sales, "%s" given', is_object($arrayOfstore_item_salesStore_item_salesItem) ? get_class($arrayOfstore_item_salesStore_item_salesItem) : gettype($arrayOfstore_item_salesStore_item_salesItem)), __LINE__);
            }
        }
        if (is_null($store_item_sales) || (is_array($store_item_sales) && empty($store_item_sales))) {
            unset($this->store_item_sales);
        } else {
            $this->store_item_sales = $store_item_sales;
        }
        return $this;
    }
    /**
     * Add item to store_item_sales value
     * @throws \InvalidArgumentException
     * @param \StructType\Store_item_sales $item
     * @return \ArrayType\ArrayOfstore_item_sales
     */
    public function addToStore_item_sales(\StructType\Store_item_sales $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Store_item_sales) {
            throw new \InvalidArgumentException(sprintf('The store_item_sales property can only contain items of \StructType\Store_item_sales, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->store_item_sales[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Store_item_sales|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Store_item_sales|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Store_item_sales|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Store_item_sales|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Store_item_sales|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string store_item_sales
     */
    public function getAttributeName()
    {
        return 'store_item_sales';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfstore_item_sales
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
