<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfshipment_cartons ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfshipment_cartons
 * @subpackage Arrays
 */
class ArrayOfshipment_cartons extends AbstractStructArrayBase
{
    /**
     * The shipment_cartons
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Shipment_cartons[]
     */
    public $shipment_cartons;
    /**
     * Constructor method for ArrayOfshipment_cartons
     * @uses ArrayOfshipment_cartons::setShipment_cartons()
     * @param \StructType\Shipment_cartons[] $shipment_cartons
     */
    public function __construct(array $shipment_cartons = array())
    {
        $this
            ->setShipment_cartons($shipment_cartons);
    }
    /**
     * Get shipment_cartons value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Shipment_cartons[]|null
     */
    public function getShipment_cartons()
    {
        return isset($this->shipment_cartons) ? $this->shipment_cartons : null;
    }
    /**
     * Set shipment_cartons value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Shipment_cartons[] $shipment_cartons
     * @return \ArrayType\ArrayOfshipment_cartons
     */
    public function setShipment_cartons(array $shipment_cartons = array())
    {
        foreach ($shipment_cartons as $arrayOfshipment_cartonsShipment_cartonsItem) {
            // validation for constraint: itemType
            if (!$arrayOfshipment_cartonsShipment_cartonsItem instanceof \StructType\Shipment_cartons) {
                throw new \InvalidArgumentException(sprintf('The shipment_cartons property can only contain items of \StructType\Shipment_cartons, "%s" given', is_object($arrayOfshipment_cartonsShipment_cartonsItem) ? get_class($arrayOfshipment_cartonsShipment_cartonsItem) : gettype($arrayOfshipment_cartonsShipment_cartonsItem)), __LINE__);
            }
        }
        if (is_null($shipment_cartons) || (is_array($shipment_cartons) && empty($shipment_cartons))) {
            unset($this->shipment_cartons);
        } else {
            $this->shipment_cartons = $shipment_cartons;
        }
        return $this;
    }
    /**
     * Add item to shipment_cartons value
     * @throws \InvalidArgumentException
     * @param \StructType\Shipment_cartons $item
     * @return \ArrayType\ArrayOfshipment_cartons
     */
    public function addToShipment_cartons(\StructType\Shipment_cartons $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Shipment_cartons) {
            throw new \InvalidArgumentException(sprintf('The shipment_cartons property can only contain items of \StructType\Shipment_cartons, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->shipment_cartons[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Shipment_cartons|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Shipment_cartons|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Shipment_cartons|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Shipment_cartons|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Shipment_cartons|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string shipment_cartons
     */
    public function getAttributeName()
    {
        return 'shipment_cartons';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfshipment_cartons
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
