<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfinvoice_line ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfinvoice_line
 * @subpackage Arrays
 */
class ArrayOfinvoice_line extends AbstractStructArrayBase
{
    /**
     * The invoice_line
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Invoice_line[]
     */
    public $invoice_line;
    /**
     * Constructor method for ArrayOfinvoice_line
     * @uses ArrayOfinvoice_line::setInvoice_line()
     * @param \StructType\Invoice_line[] $invoice_line
     */
    public function __construct(array $invoice_line = array())
    {
        $this
            ->setInvoice_line($invoice_line);
    }
    /**
     * Get invoice_line value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Invoice_line[]|null
     */
    public function getInvoice_line()
    {
        return isset($this->invoice_line) ? $this->invoice_line : null;
    }
    /**
     * Set invoice_line value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Invoice_line[] $invoice_line
     * @return \ArrayType\ArrayOfinvoice_line
     */
    public function setInvoice_line(array $invoice_line = array())
    {
        foreach ($invoice_line as $arrayOfinvoice_lineInvoice_lineItem) {
            // validation for constraint: itemType
            if (!$arrayOfinvoice_lineInvoice_lineItem instanceof \StructType\Invoice_line) {
                throw new \InvalidArgumentException(sprintf('The invoice_line property can only contain items of \StructType\Invoice_line, "%s" given', is_object($arrayOfinvoice_lineInvoice_lineItem) ? get_class($arrayOfinvoice_lineInvoice_lineItem) : gettype($arrayOfinvoice_lineInvoice_lineItem)), __LINE__);
            }
        }
        if (is_null($invoice_line) || (is_array($invoice_line) && empty($invoice_line))) {
            unset($this->invoice_line);
        } else {
            $this->invoice_line = $invoice_line;
        }
        return $this;
    }
    /**
     * Add item to invoice_line value
     * @throws \InvalidArgumentException
     * @param \StructType\Invoice_line $item
     * @return \ArrayType\ArrayOfinvoice_line
     */
    public function addToInvoice_line(\StructType\Invoice_line $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Invoice_line) {
            throw new \InvalidArgumentException(sprintf('The invoice_line property can only contain items of \StructType\Invoice_line, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->invoice_line[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Invoice_line|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Invoice_line|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Invoice_line|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Invoice_line|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Invoice_line|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string invoice_line
     */
    public function getAttributeName()
    {
        return 'invoice_line';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfinvoice_line
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
