<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfcatalog_item ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfcatalog_item
 * @subpackage Arrays
 */
class ArrayOfcatalog_item extends AbstractStructArrayBase
{
    /**
     * The catalog_item
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Catalog_item[]
     */
    public $catalog_item;
    /**
     * Constructor method for ArrayOfcatalog_item
     * @uses ArrayOfcatalog_item::setCatalog_item()
     * @param \StructType\Catalog_item[] $catalog_item
     */
    public function __construct(array $catalog_item = array())
    {
        $this
            ->setCatalog_item($catalog_item);
    }
    /**
     * Get catalog_item value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Catalog_item[]|null
     */
    public function getCatalog_item()
    {
        return isset($this->catalog_item) ? $this->catalog_item : null;
    }
    /**
     * Set catalog_item value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_item[] $catalog_item
     * @return \ArrayType\ArrayOfcatalog_item
     */
    public function setCatalog_item(array $catalog_item = array())
    {
        foreach ($catalog_item as $arrayOfcatalog_itemCatalog_itemItem) {
            // validation for constraint: itemType
            if (!$arrayOfcatalog_itemCatalog_itemItem instanceof \StructType\Catalog_item) {
                throw new \InvalidArgumentException(sprintf('The catalog_item property can only contain items of \StructType\Catalog_item, "%s" given', is_object($arrayOfcatalog_itemCatalog_itemItem) ? get_class($arrayOfcatalog_itemCatalog_itemItem) : gettype($arrayOfcatalog_itemCatalog_itemItem)), __LINE__);
            }
        }
        if (is_null($catalog_item) || (is_array($catalog_item) && empty($catalog_item))) {
            unset($this->catalog_item);
        } else {
            $this->catalog_item = $catalog_item;
        }
        return $this;
    }
    /**
     * Add item to catalog_item value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_item $item
     * @return \ArrayType\ArrayOfcatalog_item
     */
    public function addToCatalog_item(\StructType\Catalog_item $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Catalog_item) {
            throw new \InvalidArgumentException(sprintf('The catalog_item property can only contain items of \StructType\Catalog_item, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->catalog_item[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Catalog_item|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Catalog_item|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Catalog_item|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Catalog_item|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Catalog_item|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string catalog_item
     */
    public function getAttributeName()
    {
        return 'catalog_item';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfcatalog_item
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
