<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAsn_Line ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAsn_Line
 * @subpackage Arrays
 */
class ArrayOfAsn_Line extends AbstractStructArrayBase
{
    /**
     * The Asn_Line
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Asn_Line[]
     */
    public $Asn_Line;
    /**
     * Constructor method for ArrayOfAsn_Line
     * @uses ArrayOfAsn_Line::setAsn_Line()
     * @param \StructType\Asn_Line[] $asn_Line
     */
    public function __construct(array $asn_Line = array())
    {
        $this
            ->setAsn_Line($asn_Line);
    }
    /**
     * Get Asn_Line value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Asn_Line[]|null
     */
    public function getAsn_Line()
    {
        return isset($this->Asn_Line) ? $this->Asn_Line : null;
    }
    /**
     * Set Asn_Line value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Asn_Line[] $asn_Line
     * @return \ArrayType\ArrayOfAsn_Line
     */
    public function setAsn_Line(array $asn_Line = array())
    {
        foreach ($asn_Line as $arrayOfAsn_LineAsn_LineItem) {
            // validation for constraint: itemType
            if (!$arrayOfAsn_LineAsn_LineItem instanceof \StructType\Asn_Line) {
                throw new \InvalidArgumentException(sprintf('The Asn_Line property can only contain items of \StructType\Asn_Line, "%s" given', is_object($arrayOfAsn_LineAsn_LineItem) ? get_class($arrayOfAsn_LineAsn_LineItem) : gettype($arrayOfAsn_LineAsn_LineItem)), __LINE__);
            }
        }
        if (is_null($asn_Line) || (is_array($asn_Line) && empty($asn_Line))) {
            unset($this->Asn_Line);
        } else {
            $this->Asn_Line = $asn_Line;
        }
        return $this;
    }
    /**
     * Add item to Asn_Line value
     * @throws \InvalidArgumentException
     * @param \StructType\Asn_Line $item
     * @return \ArrayType\ArrayOfAsn_Line
     */
    public function addToAsn_Line(\StructType\Asn_Line $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asn_Line) {
            throw new \InvalidArgumentException(sprintf('The Asn_Line property can only contain items of \StructType\Asn_Line, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Asn_Line[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Asn_Line|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Asn_Line|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Asn_Line|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Asn_Line|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Asn_Line|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Asn_Line
     */
    public function getAttributeName()
    {
        return 'Asn_Line';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAsn_Line
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
