<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfstore_sales ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfstore_sales
 * @subpackage Arrays
 */
class ArrayOfstore_sales extends AbstractStructArrayBase
{
    /**
     * The store_sales
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Store_sales[]
     */
    public $store_sales;
    /**
     * Constructor method for ArrayOfstore_sales
     * @uses ArrayOfstore_sales::setStore_sales()
     * @param \StructType\Store_sales[] $store_sales
     */
    public function __construct(array $store_sales = array())
    {
        $this
            ->setStore_sales($store_sales);
    }
    /**
     * Get store_sales value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Store_sales[]|null
     */
    public function getStore_sales()
    {
        return isset($this->store_sales) ? $this->store_sales : null;
    }
    /**
     * Set store_sales value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Store_sales[] $store_sales
     * @return \ArrayType\ArrayOfstore_sales
     */
    public function setStore_sales(array $store_sales = array())
    {
        foreach ($store_sales as $arrayOfstore_salesStore_salesItem) {
            // validation for constraint: itemType
            if (!$arrayOfstore_salesStore_salesItem instanceof \StructType\Store_sales) {
                throw new \InvalidArgumentException(sprintf('The store_sales property can only contain items of \StructType\Store_sales, "%s" given', is_object($arrayOfstore_salesStore_salesItem) ? get_class($arrayOfstore_salesStore_salesItem) : gettype($arrayOfstore_salesStore_salesItem)), __LINE__);
            }
        }
        if (is_null($store_sales) || (is_array($store_sales) && empty($store_sales))) {
            unset($this->store_sales);
        } else {
            $this->store_sales = $store_sales;
        }
        return $this;
    }
    /**
     * Add item to store_sales value
     * @throws \InvalidArgumentException
     * @param \StructType\Store_sales $item
     * @return \ArrayType\ArrayOfstore_sales
     */
    public function addToStore_sales(\StructType\Store_sales $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Store_sales) {
            throw new \InvalidArgumentException(sprintf('The store_sales property can only contain items of \StructType\Store_sales, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->store_sales[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Store_sales|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Store_sales|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Store_sales|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Store_sales|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Store_sales|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string store_sales
     */
    public function getAttributeName()
    {
        return 'store_sales';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfstore_sales
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
