<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfstore_item_inventory ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfstore_item_inventory
 * @subpackage Arrays
 */
class ArrayOfstore_item_inventory extends AbstractStructArrayBase
{
    /**
     * The store_item_inventory
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Store_item_inventory[]
     */
    public $store_item_inventory;
    /**
     * Constructor method for ArrayOfstore_item_inventory
     * @uses ArrayOfstore_item_inventory::setStore_item_inventory()
     * @param \StructType\Store_item_inventory[] $store_item_inventory
     */
    public function __construct(array $store_item_inventory = array())
    {
        $this
            ->setStore_item_inventory($store_item_inventory);
    }
    /**
     * Get store_item_inventory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Store_item_inventory[]|null
     */
    public function getStore_item_inventory()
    {
        return isset($this->store_item_inventory) ? $this->store_item_inventory : null;
    }
    /**
     * Set store_item_inventory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Store_item_inventory[] $store_item_inventory
     * @return \ArrayType\ArrayOfstore_item_inventory
     */
    public function setStore_item_inventory(array $store_item_inventory = array())
    {
        foreach ($store_item_inventory as $arrayOfstore_item_inventoryStore_item_inventoryItem) {
            // validation for constraint: itemType
            if (!$arrayOfstore_item_inventoryStore_item_inventoryItem instanceof \StructType\Store_item_inventory) {
                throw new \InvalidArgumentException(sprintf('The store_item_inventory property can only contain items of \StructType\Store_item_inventory, "%s" given', is_object($arrayOfstore_item_inventoryStore_item_inventoryItem) ? get_class($arrayOfstore_item_inventoryStore_item_inventoryItem) : gettype($arrayOfstore_item_inventoryStore_item_inventoryItem)), __LINE__);
            }
        }
        if (is_null($store_item_inventory) || (is_array($store_item_inventory) && empty($store_item_inventory))) {
            unset($this->store_item_inventory);
        } else {
            $this->store_item_inventory = $store_item_inventory;
        }
        return $this;
    }
    /**
     * Add item to store_item_inventory value
     * @throws \InvalidArgumentException
     * @param \StructType\Store_item_inventory $item
     * @return \ArrayType\ArrayOfstore_item_inventory
     */
    public function addToStore_item_inventory(\StructType\Store_item_inventory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Store_item_inventory) {
            throw new \InvalidArgumentException(sprintf('The store_item_inventory property can only contain items of \StructType\Store_item_inventory, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->store_item_inventory[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Store_item_inventory|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Store_item_inventory|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Store_item_inventory|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Store_item_inventory|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Store_item_inventory|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string store_item_inventory
     */
    public function getAttributeName()
    {
        return 'store_item_inventory';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfstore_item_inventory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
