<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfstore_item ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfstore_item
 * @subpackage Arrays
 */
class ArrayOfstore_item extends AbstractStructArrayBase
{
    /**
     * The store_item
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Store_item[]
     */
    public $store_item;
    /**
     * Constructor method for ArrayOfstore_item
     * @uses ArrayOfstore_item::setStore_item()
     * @param \StructType\Store_item[] $store_item
     */
    public function __construct(array $store_item = array())
    {
        $this
            ->setStore_item($store_item);
    }
    /**
     * Get store_item value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Store_item[]|null
     */
    public function getStore_item()
    {
        return isset($this->store_item) ? $this->store_item : null;
    }
    /**
     * Set store_item value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Store_item[] $store_item
     * @return \ArrayType\ArrayOfstore_item
     */
    public function setStore_item(array $store_item = array())
    {
        foreach ($store_item as $arrayOfstore_itemStore_itemItem) {
            // validation for constraint: itemType
            if (!$arrayOfstore_itemStore_itemItem instanceof \StructType\Store_item) {
                throw new \InvalidArgumentException(sprintf('The store_item property can only contain items of \StructType\Store_item, "%s" given', is_object($arrayOfstore_itemStore_itemItem) ? get_class($arrayOfstore_itemStore_itemItem) : gettype($arrayOfstore_itemStore_itemItem)), __LINE__);
            }
        }
        if (is_null($store_item) || (is_array($store_item) && empty($store_item))) {
            unset($this->store_item);
        } else {
            $this->store_item = $store_item;
        }
        return $this;
    }
    /**
     * Add item to store_item value
     * @throws \InvalidArgumentException
     * @param \StructType\Store_item $item
     * @return \ArrayType\ArrayOfstore_item
     */
    public function addToStore_item(\StructType\Store_item $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Store_item) {
            throw new \InvalidArgumentException(sprintf('The store_item property can only contain items of \StructType\Store_item, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->store_item[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Store_item|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Store_item|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Store_item|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Store_item|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Store_item|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string store_item
     */
    public function getAttributeName()
    {
        return 'store_item';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfstore_item
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
