<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Time_Punch_TypeObjectType StructType
 * @subpackage Structs
 */
class Time_Punch_TypeObjectType extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Time_Punch_TypeObjectIDType[]
     */
    public $ID;
    /**
     * The Descriptor
     * Meta informations extracted from the WSDL
     * - documentation: Display information used to describe an instance of an object. This 'optional' information is for outbound descriptive purposes only and is not processed on inbound Workday Web Services requests.
     * @var string
     */
    public $Descriptor;
    /**
     * Constructor method for Time_Punch_TypeObjectType
     * @uses Time_Punch_TypeObjectType::setID()
     * @uses Time_Punch_TypeObjectType::setDescriptor()
     * @param \StructType\Time_Punch_TypeObjectIDType[] $iD
     * @param string $descriptor
     */
    public function __construct(array $iD = array(), $descriptor = null)
    {
        $this
            ->setID($iD)
            ->setDescriptor($descriptor);
    }
    /**
     * Get ID value
     * @return \StructType\Time_Punch_TypeObjectIDType[]|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Time_Punch_TypeObjectIDType[] $iD
     * @return \StructType\Time_Punch_TypeObjectType
     */
    public function setID(array $iD = array())
    {
        foreach ($iD as $time_Punch_TypeObjectTypeIDItem) {
            // validation for constraint: itemType
            if (!$time_Punch_TypeObjectTypeIDItem instanceof \StructType\Time_Punch_TypeObjectIDType) {
                throw new \InvalidArgumentException(sprintf('The ID property can only contain items of \StructType\Time_Punch_TypeObjectIDType, "%s" given', is_object($time_Punch_TypeObjectTypeIDItem) ? get_class($time_Punch_TypeObjectTypeIDItem) : gettype($time_Punch_TypeObjectTypeIDItem)), __LINE__);
            }
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Add item to ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Time_Punch_TypeObjectIDType $item
     * @return \StructType\Time_Punch_TypeObjectType
     */
    public function addToID(\StructType\Time_Punch_TypeObjectIDType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Time_Punch_TypeObjectIDType) {
            throw new \InvalidArgumentException(sprintf('The ID property can only contain items of \StructType\Time_Punch_TypeObjectIDType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ID[] = $item;
        return $this;
    }
    /**
     * Get Descriptor value
     * @return string|null
     */
    public function getDescriptor()
    {
        return $this->Descriptor;
    }
    /**
     * Set Descriptor value
     * @param string $descriptor
     * @return \StructType\Time_Punch_TypeObjectType
     */
    public function setDescriptor($descriptor = null)
    {
        // validation for constraint: string
        if (!is_null($descriptor) && !is_string($descriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descriptor)), __LINE__);
        }
        $this->Descriptor = $descriptor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Time_Punch_TypeObjectType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
