<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Import_Ad_Hoc_Schedules_RequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Load instances of Ad Hoc Schedule Events.
 * @subpackage Structs
 */
class Import_Ad_Hoc_Schedules_RequestType extends AbstractStructBase
{
    /**
     * The Ad_Hoc_Schedule_Data
     * Meta informations extracted from the WSDL
     * - documentation: Data related to the Ad Hoc Schedule Event to be processed.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Ad_Hoc_Schedule_Event_DataType[]
     */
    public $Ad_Hoc_Schedule_Data;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Import_Ad_Hoc_Schedules_RequestType
     * @uses Import_Ad_Hoc_Schedules_RequestType::setAd_Hoc_Schedule_Data()
     * @uses Import_Ad_Hoc_Schedules_RequestType::setVersion()
     * @param \StructType\Ad_Hoc_Schedule_Event_DataType[] $ad_Hoc_Schedule_Data
     * @param string $version
     */
    public function __construct(array $ad_Hoc_Schedule_Data = array(), $version = null)
    {
        $this
            ->setAd_Hoc_Schedule_Data($ad_Hoc_Schedule_Data)
            ->setVersion($version);
    }
    /**
     * Get Ad_Hoc_Schedule_Data value
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType[]|null
     */
    public function getAd_Hoc_Schedule_Data()
    {
        return $this->{'Ad-Hoc_Schedule_Data'};
    }
    /**
     * Set Ad_Hoc_Schedule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Ad_Hoc_Schedule_Event_DataType[] $ad_Hoc_Schedule_Data
     * @return \StructType\Import_Ad_Hoc_Schedules_RequestType
     */
    public function setAd_Hoc_Schedule_Data(array $ad_Hoc_Schedule_Data = array())
    {
        foreach ($ad_Hoc_Schedule_Data as $import_Ad_Hoc_Schedules_RequestTypeAd_Hoc_Schedule_DataItem) {
            // validation for constraint: itemType
            if (!$import_Ad_Hoc_Schedules_RequestTypeAd_Hoc_Schedule_DataItem instanceof \StructType\Ad_Hoc_Schedule_Event_DataType) {
                throw new \InvalidArgumentException(sprintf('The Ad_Hoc_Schedule_Data property can only contain items of \StructType\Ad_Hoc_Schedule_Event_DataType, "%s" given', is_object($import_Ad_Hoc_Schedules_RequestTypeAd_Hoc_Schedule_DataItem) ? get_class($import_Ad_Hoc_Schedules_RequestTypeAd_Hoc_Schedule_DataItem) : gettype($import_Ad_Hoc_Schedules_RequestTypeAd_Hoc_Schedule_DataItem)), __LINE__);
            }
        }
        $this->Ad_Hoc_Schedule_Data = $this->{'Ad-Hoc_Schedule_Data'} = $ad_Hoc_Schedule_Data;
        return $this;
    }
    /**
     */
    public function addToAd_Hoc_Schedule_Data(\StructType\Ad_Hoc_Schedule_Event_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Ad_Hoc_Schedule_Event_DataType) {
            throw new \InvalidArgumentException(sprintf('The Ad_Hoc_Schedule_Data property can only contain items of \StructType\Ad_Hoc_Schedule_Event_DataType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Ad_Hoc_Schedule_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Import_Ad_Hoc_Schedules_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Import_Ad_Hoc_Schedules_RequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
