<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Assign_Work_Schedule_RequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Imports work schedule calendar assignments.
 * @subpackage Structs
 */
class Assign_Work_Schedule_RequestType extends AbstractStructBase
{
    /**
     * The Business_Process_Parameters_Data
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Business_Process_ParametersType
     */
    public $Business_Process_Parameters_Data;
    /**
     * The Assign_Work_Schedule_Data
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Assign_Work_Schedule_DataType[]
     */
    public $Assign_Work_Schedule_Data;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Assign_Work_Schedule_RequestType
     * @uses Assign_Work_Schedule_RequestType::setBusiness_Process_Parameters_Data()
     * @uses Assign_Work_Schedule_RequestType::setAssign_Work_Schedule_Data()
     * @uses Assign_Work_Schedule_RequestType::setVersion()
     * @param \StructType\Business_Process_ParametersType $business_Process_Parameters_Data
     * @param \StructType\Assign_Work_Schedule_DataType[] $assign_Work_Schedule_Data
     * @param string $version
     */
    public function __construct(\StructType\Business_Process_ParametersType $business_Process_Parameters_Data = null, array $assign_Work_Schedule_Data = array(), $version = null)
    {
        $this
            ->setBusiness_Process_Parameters_Data($business_Process_Parameters_Data)
            ->setAssign_Work_Schedule_Data($assign_Work_Schedule_Data)
            ->setVersion($version);
    }
    /**
     * Get Business_Process_Parameters_Data value
     * @return \StructType\Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters_Data()
    {
        return $this->Business_Process_Parameters_Data;
    }
    /**
     * Set Business_Process_Parameters_Data value
     * @param \StructType\Business_Process_ParametersType $business_Process_Parameters_Data
     * @return \StructType\Assign_Work_Schedule_RequestType
     */
    public function setBusiness_Process_Parameters_Data(\StructType\Business_Process_ParametersType $business_Process_Parameters_Data = null)
    {
        $this->Business_Process_Parameters_Data = $business_Process_Parameters_Data;
        return $this;
    }
    /**
     * Get Assign_Work_Schedule_Data value
     * @return \StructType\Assign_Work_Schedule_DataType[]|null
     */
    public function getAssign_Work_Schedule_Data()
    {
        return $this->Assign_Work_Schedule_Data;
    }
    /**
     * Set Assign_Work_Schedule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Assign_Work_Schedule_DataType[] $assign_Work_Schedule_Data
     * @return \StructType\Assign_Work_Schedule_RequestType
     */
    public function setAssign_Work_Schedule_Data(array $assign_Work_Schedule_Data = array())
    {
        foreach ($assign_Work_Schedule_Data as $assign_Work_Schedule_RequestTypeAssign_Work_Schedule_DataItem) {
            // validation for constraint: itemType
            if (!$assign_Work_Schedule_RequestTypeAssign_Work_Schedule_DataItem instanceof \StructType\Assign_Work_Schedule_DataType) {
                throw new \InvalidArgumentException(sprintf('The Assign_Work_Schedule_Data property can only contain items of \StructType\Assign_Work_Schedule_DataType, "%s" given', is_object($assign_Work_Schedule_RequestTypeAssign_Work_Schedule_DataItem) ? get_class($assign_Work_Schedule_RequestTypeAssign_Work_Schedule_DataItem) : gettype($assign_Work_Schedule_RequestTypeAssign_Work_Schedule_DataItem)), __LINE__);
            }
        }
        $this->Assign_Work_Schedule_Data = $assign_Work_Schedule_Data;
        return $this;
    }
    /**
     * Add item to Assign_Work_Schedule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Assign_Work_Schedule_DataType $item
     * @return \StructType\Assign_Work_Schedule_RequestType
     */
    public function addToAssign_Work_Schedule_Data(\StructType\Assign_Work_Schedule_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Assign_Work_Schedule_DataType) {
            throw new \InvalidArgumentException(sprintf('The Assign_Work_Schedule_Data property can only contain items of \StructType\Assign_Work_Schedule_DataType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Assign_Work_Schedule_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Assign_Work_Schedule_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Assign_Work_Schedule_RequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
