<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Work_Schedule_CalendarObjectType StructType
 * @subpackage Structs
 */
class Work_Schedule_CalendarObjectType extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Work_Schedule_CalendarObjectIDType[]
     */
    public $ID;
    /**
     * The Descriptor
     * Meta informations extracted from the WSDL
     * - documentation: Display information used to describe an instance of an object. This 'optional' information is for outbound descriptive purposes only and is not processed on inbound Workday Web Services requests.
     * @var string
     */
    public $Descriptor;
    /**
     * Constructor method for Work_Schedule_CalendarObjectType
     * @uses Work_Schedule_CalendarObjectType::setID()
     * @uses Work_Schedule_CalendarObjectType::setDescriptor()
     * @param \StructType\Work_Schedule_CalendarObjectIDType[] $iD
     * @param string $descriptor
     */
    public function __construct(array $iD = array(), $descriptor = null)
    {
        $this
            ->setID($iD)
            ->setDescriptor($descriptor);
    }
    /**
     * Get ID value
     * @return \StructType\Work_Schedule_CalendarObjectIDType[]|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Work_Schedule_CalendarObjectIDType[] $iD
     * @return \StructType\Work_Schedule_CalendarObjectType
     */
    public function setID(array $iD = array())
    {
        foreach ($iD as $work_Schedule_CalendarObjectTypeIDItem) {
            // validation for constraint: itemType
            if (!$work_Schedule_CalendarObjectTypeIDItem instanceof \StructType\Work_Schedule_CalendarObjectIDType) {
                throw new \InvalidArgumentException(sprintf('The ID property can only contain items of \StructType\Work_Schedule_CalendarObjectIDType, "%s" given', is_object($work_Schedule_CalendarObjectTypeIDItem) ? get_class($work_Schedule_CalendarObjectTypeIDItem) : gettype($work_Schedule_CalendarObjectTypeIDItem)), __LINE__);
            }
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Add item to ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Work_Schedule_CalendarObjectIDType $item
     * @return \StructType\Work_Schedule_CalendarObjectType
     */
    public function addToID(\StructType\Work_Schedule_CalendarObjectIDType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Work_Schedule_CalendarObjectIDType) {
            throw new \InvalidArgumentException(sprintf('The ID property can only contain items of \StructType\Work_Schedule_CalendarObjectIDType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ID[] = $item;
        return $this;
    }
    /**
     * Get Descriptor value
     * @return string|null
     */
    public function getDescriptor()
    {
        return $this->Descriptor;
    }
    /**
     * Set Descriptor value
     * @param string $descriptor
     * @return \StructType\Work_Schedule_CalendarObjectType
     */
    public function setDescriptor($descriptor = null)
    {
        // validation for constraint: string
        if (!is_null($descriptor) && !is_string($descriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descriptor)), __LINE__);
        }
        $this->Descriptor = $descriptor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Work_Schedule_CalendarObjectType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
