<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Unique_IdentifierObjectType StructType
 * @subpackage Structs
 */
class Unique_IdentifierObjectType extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectIDType[]
     */
    public $ID;
    /**
     * The Descriptor
     * Meta informations extracted from the WSDL
     * - documentation: Display information used to describe an instance of an object. This 'optional' information is for outbound descriptive purposes only and is not processed on inbound Workday Web Services requests.
     * @var string
     */
    public $Descriptor;
    /**
     * Constructor method for Unique_IdentifierObjectType
     * @uses Unique_IdentifierObjectType::setID()
     * @uses Unique_IdentifierObjectType::setDescriptor()
     * @param \StructType\Unique_IdentifierObjectIDType[] $iD
     * @param string $descriptor
     */
    public function __construct(array $iD = array(), $descriptor = null)
    {
        $this
            ->setID($iD)
            ->setDescriptor($descriptor);
    }
    /**
     * Get ID value
     * @return \StructType\Unique_IdentifierObjectIDType[]|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectIDType[] $iD
     * @return \StructType\Unique_IdentifierObjectType
     */
    public function setID(array $iD = array())
    {
        foreach ($iD as $unique_IdentifierObjectTypeIDItem) {
            // validation for constraint: itemType
            if (!$unique_IdentifierObjectTypeIDItem instanceof \StructType\Unique_IdentifierObjectIDType) {
                throw new \InvalidArgumentException(sprintf('The ID property can only contain items of \StructType\Unique_IdentifierObjectIDType, "%s" given', is_object($unique_IdentifierObjectTypeIDItem) ? get_class($unique_IdentifierObjectTypeIDItem) : gettype($unique_IdentifierObjectTypeIDItem)), __LINE__);
            }
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Add item to ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectIDType $item
     * @return \StructType\Unique_IdentifierObjectType
     */
    public function addToID(\StructType\Unique_IdentifierObjectIDType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unique_IdentifierObjectIDType) {
            throw new \InvalidArgumentException(sprintf('The ID property can only contain items of \StructType\Unique_IdentifierObjectIDType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ID[] = $item;
        return $this;
    }
    /**
     * Get Descriptor value
     * @return string|null
     */
    public function getDescriptor()
    {
        return $this->Descriptor;
    }
    /**
     * Set Descriptor value
     * @param string $descriptor
     * @return \StructType\Unique_IdentifierObjectType
     */
    public function setDescriptor($descriptor = null)
    {
        // validation for constraint: string
        if (!is_null($descriptor) && !is_string($descriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descriptor)), __LINE__);
        }
        $this->Descriptor = $descriptor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Unique_IdentifierObjectType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
