<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Import_Reported_Time_Blocks_RequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Load instances of Reported Time Blocks.
 * @subpackage Structs
 */
class Import_Reported_Time_Blocks_RequestType extends AbstractStructBase
{
    /**
     * The Reported_Time_Block_Data
     * Meta informations extracted from the WSDL
     * - documentation: Data related to the reported time block(s) to be processed.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Reported_Time_Block_DataType[]
     */
    public $Reported_Time_Block_Data;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Import_Reported_Time_Blocks_RequestType
     * @uses Import_Reported_Time_Blocks_RequestType::setReported_Time_Block_Data()
     * @uses Import_Reported_Time_Blocks_RequestType::setVersion()
     * @param \StructType\Reported_Time_Block_DataType[] $reported_Time_Block_Data
     * @param string $version
     */
    public function __construct(array $reported_Time_Block_Data = array(), $version = null)
    {
        $this
            ->setReported_Time_Block_Data($reported_Time_Block_Data)
            ->setVersion($version);
    }
    /**
     * Get Reported_Time_Block_Data value
     * @return \StructType\Reported_Time_Block_DataType[]|null
     */
    public function getReported_Time_Block_Data()
    {
        return $this->Reported_Time_Block_Data;
    }
    /**
     * Set Reported_Time_Block_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Reported_Time_Block_DataType[] $reported_Time_Block_Data
     * @return \StructType\Import_Reported_Time_Blocks_RequestType
     */
    public function setReported_Time_Block_Data(array $reported_Time_Block_Data = array())
    {
        foreach ($reported_Time_Block_Data as $import_Reported_Time_Blocks_RequestTypeReported_Time_Block_DataItem) {
            // validation for constraint: itemType
            if (!$import_Reported_Time_Blocks_RequestTypeReported_Time_Block_DataItem instanceof \StructType\Reported_Time_Block_DataType) {
                throw new \InvalidArgumentException(sprintf('The Reported_Time_Block_Data property can only contain items of \StructType\Reported_Time_Block_DataType, "%s" given', is_object($import_Reported_Time_Blocks_RequestTypeReported_Time_Block_DataItem) ? get_class($import_Reported_Time_Blocks_RequestTypeReported_Time_Block_DataItem) : gettype($import_Reported_Time_Blocks_RequestTypeReported_Time_Block_DataItem)), __LINE__);
            }
        }
        $this->Reported_Time_Block_Data = $reported_Time_Block_Data;
        return $this;
    }
    /**
     * Add item to Reported_Time_Block_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Reported_Time_Block_DataType $item
     * @return \StructType\Import_Reported_Time_Blocks_RequestType
     */
    public function addToReported_Time_Block_Data(\StructType\Reported_Time_Block_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Reported_Time_Block_DataType) {
            throw new \InvalidArgumentException(sprintf('The Reported_Time_Block_Data property can only contain items of \StructType\Reported_Time_Block_DataType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Reported_Time_Block_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Import_Reported_Time_Blocks_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Import_Reported_Time_Blocks_RequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
