<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Event_Attachment_CategoryObjectType StructType
 * @subpackage Structs
 */
class Event_Attachment_CategoryObjectType extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Event_Attachment_CategoryObjectIDType[]
     */
    public $ID;
    /**
     * The Descriptor
     * Meta informations extracted from the WSDL
     * - documentation: Display information used to describe an instance of an object. This 'optional' information is for outbound descriptive purposes only and is not processed on inbound Workday Web Services requests.
     * @var string
     */
    public $Descriptor;
    /**
     * Constructor method for Event_Attachment_CategoryObjectType
     * @uses Event_Attachment_CategoryObjectType::setID()
     * @uses Event_Attachment_CategoryObjectType::setDescriptor()
     * @param \StructType\Event_Attachment_CategoryObjectIDType[] $iD
     * @param string $descriptor
     */
    public function __construct(array $iD = array(), $descriptor = null)
    {
        $this
            ->setID($iD)
            ->setDescriptor($descriptor);
    }
    /**
     * Get ID value
     * @return \StructType\Event_Attachment_CategoryObjectIDType[]|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Event_Attachment_CategoryObjectIDType[] $iD
     * @return \StructType\Event_Attachment_CategoryObjectType
     */
    public function setID(array $iD = array())
    {
        foreach ($iD as $event_Attachment_CategoryObjectTypeIDItem) {
            // validation for constraint: itemType
            if (!$event_Attachment_CategoryObjectTypeIDItem instanceof \StructType\Event_Attachment_CategoryObjectIDType) {
                throw new \InvalidArgumentException(sprintf('The ID property can only contain items of \StructType\Event_Attachment_CategoryObjectIDType, "%s" given', is_object($event_Attachment_CategoryObjectTypeIDItem) ? get_class($event_Attachment_CategoryObjectTypeIDItem) : gettype($event_Attachment_CategoryObjectTypeIDItem)), __LINE__);
            }
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Add item to ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Event_Attachment_CategoryObjectIDType $item
     * @return \StructType\Event_Attachment_CategoryObjectType
     */
    public function addToID(\StructType\Event_Attachment_CategoryObjectIDType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Event_Attachment_CategoryObjectIDType) {
            throw new \InvalidArgumentException(sprintf('The ID property can only contain items of \StructType\Event_Attachment_CategoryObjectIDType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ID[] = $item;
        return $this;
    }
    /**
     * Get Descriptor value
     * @return string|null
     */
    public function getDescriptor()
    {
        return $this->Descriptor;
    }
    /**
     * Set Descriptor value
     * @param string $descriptor
     * @return \StructType\Event_Attachment_CategoryObjectType
     */
    public function setDescriptor($descriptor = null)
    {
        // validation for constraint: string
        if (!is_null($descriptor) && !is_string($descriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descriptor)), __LINE__);
        }
        $this->Descriptor = $descriptor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Event_Attachment_CategoryObjectType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
