<?php

namespace EnumType;

/**
 * This class stands for Time_TypeReferenceEnumeration EnumType
 * @subpackage Enumerations
 */
class Time_TypeReferenceEnumeration
{
    /**
     * Constant for value 'WID'
     * @return string 'WID'
     */
    const VALUE_WID = 'WID';
    /**
     * Constant for value 'Absence_Table_ID'
     * @return string 'Absence_Table_ID'
     */
    const VALUE_ABSENCE_TABLE_ID = 'Absence_Table_ID';
    /**
     * Constant for value 'Project_ID'
     * @return string 'Project_ID'
     */
    const VALUE_PROJECT_ID = 'Project_ID';
    /**
     * Constant for value 'Project_Plan_ID'
     * @return string 'Project_Plan_ID'
     */
    const VALUE_PROJECT_PLAN_ID = 'Project_Plan_ID';
    /**
     * Constant for value 'Time_Code_Reference_ID'
     * @return string 'Time_Code_Reference_ID'
     */
    const VALUE_TIME_CODE_REFERENCE_ID = 'Time_Code_Reference_ID';
    /**
     * Constant for value 'Time_Off_Code'
     * @return string 'Time_Off_Code'
     */
    const VALUE_TIME_OFF_CODE = 'Time_Off_Code';
    /**
     * Constant for value 'Workday_Absence_Code'
     * @return string 'Workday_Absence_Code'
     */
    const VALUE_WORKDAY_ABSENCE_CODE = 'Workday_Absence_Code';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WID
     * @uses self::VALUE_ABSENCE_TABLE_ID
     * @uses self::VALUE_PROJECT_ID
     * @uses self::VALUE_PROJECT_PLAN_ID
     * @uses self::VALUE_TIME_CODE_REFERENCE_ID
     * @uses self::VALUE_TIME_OFF_CODE
     * @uses self::VALUE_WORKDAY_ABSENCE_CODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WID,
            self::VALUE_ABSENCE_TABLE_ID,
            self::VALUE_PROJECT_ID,
            self::VALUE_PROJECT_PLAN_ID,
            self::VALUE_TIME_CODE_REFERENCE_ID,
            self::VALUE_TIME_OFF_CODE,
            self::VALUE_WORKDAY_ABSENCE_CODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
