<?php

namespace EnumType;

/**
 * This class stands for Time_Punch_TypeReferenceEnumeration EnumType
 * @subpackage Enumerations
 */
class Time_Punch_TypeReferenceEnumeration
{
    /**
     * Constant for value 'WID'
     * @return string 'WID'
     */
    const VALUE_WID = 'WID';
    /**
     * Constant for value 'Clock_Event_Type'
     * @return string 'Clock_Event_Type'
     */
    const VALUE_CLOCK_EVENT_TYPE = 'Clock_Event_Type';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WID
     * @uses self::VALUE_CLOCK_EVENT_TYPE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WID,
            self::VALUE_CLOCK_EVENT_TYPE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
