<?php

namespace EnumType;

/**
 * This class stands for Custom_Worktag_14ReferenceEnumeration EnumType
 * @subpackage Enumerations
 */
class Custom_Worktag_14ReferenceEnumeration
{
    /**
     * Constant for value 'WID'
     * @return string 'WID'
     */
    const VALUE_WID = 'WID';
    /**
     * Constant for value 'Custom_Worktag_14_ID'
     * @return string 'Custom_Worktag_14_ID'
     */
    const VALUE_CUSTOM_WORKTAG_14_ID = 'Custom_Worktag_14_ID';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WID
     * @uses self::VALUE_CUSTOM_WORKTAG_14_ID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WID,
            self::VALUE_CUSTOM_WORKTAG_14_ID,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
