<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://wd2-impl-services1.workday.com/ccx/service/fedex12/Time_Tracking/v31.1?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://wd2-impl-services1.workday.com/ccx/service/fedex12/Time_Tracking/v31.1?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Put ServiceType
 */
$put = new \ServiceType\Put($options);
$put->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Put_Time_Clock_Events operation/method
 */
if ($put->Put_Time_Clock_Events(new \StructType\Put_Time_Clock_Events_RequestType()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Samples for Assign ServiceType
 */
$assign = new \ServiceType\Assign($options);
$assign->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Assign_Work_Schedule operation/method
 */
if ($assign->Assign_Work_Schedule(new \StructType\Assign_Work_Schedule_RequestType()) !== false) {
    print_r($assign->getResult());
} else {
    print_r($assign->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Get_Calculated_Time_Blocks operation/method
 */
if ($get->Get_Calculated_Time_Blocks(new \StructType\Get_Calculated_Time_Blocks_RequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Import ServiceType
 */
$import = new \ServiceType\Import($options);
$import->setSoapHeaderWorkday_Common_Header($Workday_Common_Header);
/**
 * Sample call for Import_Reported_Time_Blocks operation/method
 */
if ($import->Import_Reported_Time_Blocks(new \StructType\Import_Reported_Time_Blocks_RequestType()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for Import_Time_Clock_Events operation/method
 */
if ($import->Import_Time_Clock_Events(new \StructType\Import_Time_Clock_Events_RequestType()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for Import_Ad_Hoc_Schedules operation/method
 */
if ($import->Import_Ad_Hoc_Schedules(new \StructType\Import_Ad_Hoc_Schedules_RequestType()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
