<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WorkerObjectType StructType
 * @subpackage Structs
 */
class WorkerObjectType extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectIDType[]
     */
    public $ID;
    /**
     * The Descriptor
     * Meta informations extracted from the WSDL
     * - documentation: Display information used to describe an instance of an object. This 'optional' information is for outbound descriptive purposes only and is not processed on inbound Workday Web Services requests.
     * @var string
     */
    public $Descriptor;
    /**
     * Constructor method for WorkerObjectType
     * @uses WorkerObjectType::setID()
     * @uses WorkerObjectType::setDescriptor()
     * @param \StructType\WorkerObjectIDType[] $iD
     * @param string $descriptor
     */
    public function __construct(array $iD = array(), $descriptor = null)
    {
        $this
            ->setID($iD)
            ->setDescriptor($descriptor);
    }
    /**
     * Get ID value
     * @return \StructType\WorkerObjectIDType[]|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectIDType[] $iD
     * @return \StructType\WorkerObjectType
     */
    public function setID(array $iD = array())
    {
        foreach ($iD as $workerObjectTypeIDItem) {
            // validation for constraint: itemType
            if (!$workerObjectTypeIDItem instanceof \StructType\WorkerObjectIDType) {
                throw new \InvalidArgumentException(sprintf('The ID property can only contain items of \StructType\WorkerObjectIDType, "%s" given', is_object($workerObjectTypeIDItem) ? get_class($workerObjectTypeIDItem) : gettype($workerObjectTypeIDItem)), __LINE__);
            }
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Add item to ID value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectIDType $item
     * @return \StructType\WorkerObjectType
     */
    public function addToID(\StructType\WorkerObjectIDType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectIDType) {
            throw new \InvalidArgumentException(sprintf('The ID property can only contain items of \StructType\WorkerObjectIDType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ID[] = $item;
        return $this;
    }
    /**
     * Get Descriptor value
     * @return string|null
     */
    public function getDescriptor()
    {
        return $this->Descriptor;
    }
    /**
     * Set Descriptor value
     * @param string $descriptor
     * @return \StructType\WorkerObjectType
     */
    public function setDescriptor($descriptor = null)
    {
        // validation for constraint: string
        if (!is_null($descriptor) && !is_string($descriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descriptor)), __LINE__);
        }
        $this->Descriptor = $descriptor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WorkerObjectType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
